/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.forms.client.display.process.QuickNewProcessInstancePopup;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListFilterSettingsManager;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessInstanceListScreen")
public class ProcessInstanceListPresenter
extends AbstractMultiGridPresenter<ProcessInstanceSummary, ProcessInstanceListView> {
    protected final List<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
    private final Constants constants = Constants.INSTANCE;
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    private Caller<ProcessService> processService;
    protected Event<ProcessInstanceSelectionEvent> processInstanceSelectionEvent;

    @Inject
    public void setProcessInstanceSelectedEvent(Event<ProcessInstanceSelectionEvent> processInstanceSelectionEvent) {
        this.processInstanceSelectionEvent = processInstanceSelectionEvent;
    }

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Instances());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Instances(), detailLabel, "ProcessInstanceDetailsScreen");
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(int startRange, FilterSettings tableSettings, boolean lastPage) {
        return ((ErrorHandlerBuilder)this.errorHandlerBuilder.get()).withUUID(tableSettings.getUUID()).withDataSetCallback(dataSet -> {
            HashSet<String> columns = new HashSet<String>();
            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                Long processInstanceId = DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i);
                String variableName = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"variableId", (int)i);
                String variableValue = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"value", (int)i);
                for (ProcessInstanceSummary pis : this.myProcessInstancesFromDataSet) {
                    String initiator = pis.getInitiator();
                    if (!pis.getProcessInstanceId().equals(processInstanceId) || this.filterInitiator(variableName, variableValue, initiator)) continue;
                    pis.addDomainData(variableName, variableValue);
                    columns.add(variableName);
                }
            }
            ((ProcessInstanceListView)this.view).addDomainSpecifColumns(columns);
            this.updateDataOnCallback(this.myProcessInstancesFromDataSet, startRange, startRange + this.myProcessInstancesFromDataSet.size(), lastPage);
        }).withEmptyResultsCallback(() -> this.setEmptyResults());
    }

    protected boolean filterInitiator(String variableName, String variableValue, String initiator) {
        return variableName.equals("initiator") && variableValue.equals(initiator);
    }

    protected DataSetReadyCallback getDataSetReadyCallback(Integer startRange, FilterSettings tableSettings) {
        return ((ErrorHandlerBuilder)this.errorHandlerBuilder.get()).withUUID(tableSettings.getUUID()).withDataSetCallback(dataSet -> {
            if (dataSet != null && this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                String filterValue;
                this.myProcessInstancesFromDataSet.clear();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    this.myProcessInstancesFromDataSet.add(this.createProcessInstanceSummaryFromDataSet((DataSet)dataSet, i));
                }
                boolean lastPage = false;
                if (dataSet.getRowCount() < ((ProcessInstanceListView)this.view).getListGrid().getPageSize()) {
                    lastPage = true;
                }
                if ((filterValue = this.isFilteredByProcessId(tableSettings.getDataSetLookup().getOperationList())) != null) {
                    this.getDomainSpecifDataForProcessInstances(startRange, this.myProcessInstancesFromDataSet, lastPage);
                } else {
                    this.updateDataOnCallback(this.myProcessInstancesFromDataSet, startRange, startRange + this.myProcessInstancesFromDataSet.size(), lastPage);
                }
            }
            ((ProcessInstanceListView)this.view).hideBusyIndicator();
        }).withEmptyResultsCallback(() -> this.setEmptyResults());
    }

    protected void removeActiveFilter(ColumnFilter columnFilter) {
        if (this.isFilteredByProcessId(columnFilter) != null) {
            ((ProcessInstanceListView)this.view).removeDomainSpecifColumns();
        }
        super.removeActiveFilter(columnFilter);
    }

    protected String isFilteredByProcessId(ColumnFilter filter) {
        if (filter instanceof CoreFunctionFilter) {
            List parameters;
            CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
            if (filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) && ((CoreFunctionFilter)filter).getType() == CoreFunctionType.EQUALS_TO && (parameters = coreFilter.getParameters()).size() > 0) {
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                String processId = this.isFilteredByProcessId(filter);
                if (processId == null) continue;
                return processId;
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(Integer startRange, List<ProcessInstanceSummary> instancesFromDataSet, Boolean lastPage) {
        List processIds = instancesFromDataSet.stream().map(t -> (Long)t.getId()).collect(Collectors.toList());
        FilterSettings variablesTableSettings = this.filterSettingsManager.getVariablesFilterSettings(processIds);
        variablesTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("processInstanceId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, variablesTableSettings, lastPage));
    }

    protected ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(this.getSelectedServerTemplate(), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"externalId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processName", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processVersion", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"status", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"start_date", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"end_date", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"user_identity", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processInstanceDescription", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"correlationKey", (int)i), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"parentProcessInstanceId", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"lastModificationDate", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"slaCompliance", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"sla_due_date", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"errorCount", (int)i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    public void abortProcessInstance(String containerId, long processInstanceId) {
        ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance(processInstanceId));
        ((ProcessService)this.processService.call(v -> this.refreshGrid())).abortProcessInstance(new ProcessInstanceKey(this.getSelectedServerTemplate(), containerId, Long.valueOf(processInstanceId)));
    }

    public void abortProcessInstances(Map<String, List<Long>> containerInstances) {
        ((ProcessService)this.processService.call(v -> this.refreshGrid())).abortProcessInstances(this.getSelectedServerTemplate(), containerInstances);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        StringBuilder processIdsParam = new StringBuilder();
        StringBuilder deploymentIdsParam = new StringBuilder();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.Signaling_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            processIdsParam.append(selected.getId() + ",");
            deploymentIdsParam.append(selected.getDeploymentId() + ",");
        }
        if (processIdsParam.length() == 0) {
            return;
        }
        processIdsParam.deleteCharAt(processIdsParam.length() - 1);
        deploymentIdsParam.deleteCharAt(deploymentIdsParam.length() - 1);
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        placeRequestImpl.addParameter("deploymentId", deploymentIdsParam.toString());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        HashMap<String, List<Long>> containerInstances = new HashMap<String, List<Long>>();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            containerInstances.computeIfAbsent(selected.getDeploymentId(), key -> new ArrayList()).add(selected.getProcessInstanceId());
            ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance(selected.getId()));
        }
        if (containerInstances.size() > 0) {
            this.abortProcessInstances(containerInstances);
        }
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new PrimaryActionMenuBuilder(this.constants.New_Process_Instance(), () -> {
            String selectedServerTemplate = this.getSelectedServerTemplate();
            if (selectedServerTemplate != null && !selectedServerTemplate.isEmpty()) {
                this.newProcessInstancePopup.show(selectedServerTemplate);
            } else {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.SelectServerTemplate());
            }
        })).endMenu()).build();
    }

    public void signalProcessInstance(ProcessInstanceSummary processInstance) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
        placeRequestImpl.addParameter("deploymentId", processInstance.getDeploymentId());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void selectSummaryItem(ProcessInstanceSummary summary) {
        this.setupDetailBreadcrumb(this.constants.ProcessInstanceBreadcrumb(summary.getProcessInstanceId()));
        this.placeManager.goTo("ProcessInstanceDetailsScreen");
        this.processInstanceSelectionEvent.fire((Object)new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), false));
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            this.refreshGrid();
        }
    }

    @Inject
    public void setFilterSettingsManager(ProcessInstanceListFilterSettingsManager filterSettingsManager) {
        super.setFilterSettingsManager((FilterSettingsManager)filterSettingsManager);
    }

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    public void setupActiveSearchFilters() {
        Optional processInstanceSearch;
        boolean hasSearchParam = false;
        Optional processDefinitionSearch = this.getSearchParameter("processDefinitionId");
        if (processDefinitionSearch.isPresent()) {
            String processDefinitionId = (String)processDefinitionSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)processDefinitionId)), this.constants.Process_Definition_Id(), processDefinitionId, processDefinitionId, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)v))));
            hasSearchParam = true;
        }
        if ((processInstanceSearch = this.getSearchParameter("processInstanceId")).isPresent()) {
            String processInstanceId = (String)processInstanceSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)Integer.valueOf(processInstanceId)), this.constants.Id(), processInstanceId, Integer.valueOf(processInstanceId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)v)));
            hasSearchParam = true;
        }
        if (!hasSearchParam) {
            this.setupDefaultActiveSearchFilters();
        }
    }

    public void setupDefaultActiveSearchFilters() {
        this.addActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)Integer.valueOf(1)), this.constants.State(), this.constants.Active(), 1, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)v)));
    }

    public void openJobsView(String pid) {
        this.navigateToPerspective("Requests", "processInstanceId", pid);
    }

    public void openTaskView(String pid) {
        this.navigateToPerspective(this.isUserAuthorizedForPerspective("TaskAdmin") ? "TaskAdmin" : "Tasks", "processInstanceId", pid);
    }

    public void openErrorView(String pid) {
        DefaultPlaceRequest request = new DefaultPlaceRequest("ExecutionErrors");
        request.addParameter("processInstanceId", pid);
        request.addParameter("isErrorAck", Boolean.toString(false));
        this.placeManager.goTo((PlaceRequest)request);
    }

    public Predicate<ProcessInstanceSummary> getSignalActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getAbortActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getViewJobsActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("Requests");
    }

    public Predicate<ProcessInstanceSummary> getViewTasksActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("TaskAdmin") || this.isUserAuthorizedForPerspective("Tasks");
    }

    public Predicate<ProcessInstanceSummary> getViewErrorsActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ExecutionErrors") && pis.getErrorCount() != null && pis.getErrorCount() > 0;
    }

    public static interface ProcessInstanceListView
    extends MultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter> {
        public void addDomainSpecifColumns(Set<String> var1);

        public void removeDomainSpecifColumns();
    }
}

