/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerType;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListFilterSettingsManager;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListFilterSettingsManagerTest {
    @Mock
    UserPreferencesService userPreferencesService;
    Caller<UserPreferencesService> preferencesService;
    @Mock
    FilterSettingsJSONMarshaller marshaller;
    @InjectMocks
    ProcessInstanceListFilterSettingsManager manager;

    @Before
    public void init() {
        this.preferencesService = new CallerMock((Object)this.userPreferencesService);
        this.manager.setPreferencesService(this.preferencesService);
    }

    @Test
    public void testDefaultFilters() {
        Consumer<List> callback = filters -> {
            Assert.assertEquals((long)3L, (long)filters.size());
            Assert.assertEquals((Object)Constants.INSTANCE.Active(), (Object)((SavedFilter)filters.get(0)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Completed(), (Object)((SavedFilter)filters.get(1)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Aborted(), (Object)((SavedFilter)filters.get(2)).getName());
        };
        MultiGridPreferencesStore store = new MultiGridPreferencesStore();
        this.manager.loadSavedFiltersFromPreferences(store, callback);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesService)).saveUserPreferences((UserPreference)store);
    }

    @Test
    public void testVariablesFilterSettings() {
        List<Long> processIds = Collections.singletonList(1L);
        FilterSettings settings = this.manager.getVariablesFilterSettings(processIds);
        Assert.assertNotNull((Object)settings.getDataSetLookup());
        DataSetLookup dataSetLookup = settings.getDataSetLookup();
        Assert.assertEquals((Object)"jbpmProcessInstancesWithVariables", (Object)dataSetLookup.getDataSetUUID());
        Assert.assertEquals((Object)"processInstanceId", (Object)settings.getTableDefaultSortColumnId());
        Assert.assertEquals((Object)SortOrder.ASCENDING, (Object)settings.getTableDefaultSortOrder());
        Assert.assertEquals((Object)DisplayerType.TABLE, (Object)settings.getType());
        Assert.assertEquals((Object)true, (Object)settings.isFilterEnabled());
        Assert.assertEquals((Object)true, (Object)settings.isFilterSelfApplyEnabled());
        Assert.assertEquals((Object)true, (Object)settings.isFilterNotificationEnabled());
        Assert.assertEquals((long)-1L, (long)dataSetLookup.getNumberOfRows());
        Assert.assertEquals((long)0L, (long)dataSetLookup.getRowOffset());
        Assert.assertNotNull((Object)dataSetLookup.getFirstFilterOp());
        DataSetFilter firstFilterOp = dataSetLookup.getFirstFilterOp();
        Assert.assertEquals((Object)DataSetOpType.FILTER, (Object)firstFilterOp.getType());
        Assert.assertEquals((long)1L, (long)firstFilterOp.getColumnFilterList().size());
        ColumnFilter columnFilter = (ColumnFilter)firstFilterOp.getColumnFilterList().get(0);
        Assert.assertEquals((Object)"processInstanceId", (Object)columnFilter.getColumnId());
        Assert.assertTrue((boolean)(columnFilter instanceof CoreFunctionFilter));
        Assert.assertEquals((Object)CoreFunctionType.IN, (Object)((CoreFunctionFilter)columnFilter).getType());
        Assert.assertEquals((long)1L, (long)((CoreFunctionFilter)columnFilter).getParameters().size());
        Assert.assertEquals((Object)processIds.get(0), ((CoreFunctionFilter)columnFilter).getParameters().get(0));
        DataSetGroup groupOp = dataSetLookup.getLastGroupOp();
        Assert.assertEquals((Object)DataSetOpType.GROUP, (Object)groupOp.getType());
        Assert.assertEquals((Object)false, (Object)groupOp.isJoin());
        Assert.assertEquals((long)5L, (long)groupOp.getGroupFunctions().size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(0)).getColumnId());
        Assert.assertEquals((Object)"processInstanceId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(0)).getSourceId());
        Assert.assertEquals((Object)"processId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(1)).getColumnId());
        Assert.assertEquals((Object)"processId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(1)).getSourceId());
        Assert.assertEquals((Object)"id", (Object)((GroupFunction)groupOp.getGroupFunctions().get(2)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((GroupFunction)groupOp.getGroupFunctions().get(2)).getSourceId());
        Assert.assertEquals((Object)"variableId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(3)).getColumnId());
        Assert.assertEquals((Object)"variableId", (Object)((GroupFunction)groupOp.getGroupFunctions().get(3)).getSourceId());
        Assert.assertEquals((Object)"value", (Object)((GroupFunction)groupOp.getGroupFunctions().get(4)).getColumnId());
        Assert.assertEquals((Object)"value", (Object)((GroupFunction)groupOp.getGroupFunctions().get(4)).getSourceId());
        Assert.assertEquals((long)5L, (long)settings.getColumnSettingsList().size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnSettings)settings.getColumnSettingsList().get(0)).getColumnId());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnSettings)settings.getColumnSettingsList().get(0)).getColumnName());
        Assert.assertEquals((Object)"processId", (Object)((ColumnSettings)settings.getColumnSettingsList().get(1)).getColumnId());
        Assert.assertEquals((Object)"processName", (Object)((ColumnSettings)settings.getColumnSettingsList().get(1)).getColumnName());
        Assert.assertEquals((Object)"id", (Object)((ColumnSettings)settings.getColumnSettingsList().get(2)).getColumnId());
        Assert.assertEquals((Object)"variableID", (Object)((ColumnSettings)settings.getColumnSettingsList().get(2)).getColumnName());
        Assert.assertEquals((Object)"variableId", (Object)((ColumnSettings)settings.getColumnSettingsList().get(3)).getColumnId());
        Assert.assertEquals((Object)"variableName", (Object)((ColumnSettings)settings.getColumnSettingsList().get(3)).getColumnName());
        Assert.assertEquals((Object)"value", (Object)((ColumnSettings)settings.getColumnSettingsList().get(4)).getColumnId());
        Assert.assertEquals((Object)"variableValue", (Object)((ColumnSettings)settings.getColumnSettingsList().get(4)).getColumnName());
        Assert.assertEquals((Object)"Filtered", (Object)settings.getTableName());
        Assert.assertEquals((Object)"Filtered Desc", (Object)settings.getTableDescription());
        Assert.assertEquals((Object)false, (Object)settings.isEditable());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.marshaller});
    }
}

