/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.SlaStatusConverter;
import org.jbpm.workbench.pr.client.editors.instance.ProcessInstanceSummaryAware;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.ProcessInstanceStatusUtils;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class ProcessInstanceDetailsTabPresenter
implements ProcessInstanceSummaryAware {
    private ProcessInstanceDetailsTabView view;
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Inject
    public void setView(ProcessInstanceDetailsTabView view) {
        this.view = view;
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    public void setProcessInstance(ProcessInstanceSummary process) {
        this.view.setProcessDefinitionIdText("");
        this.view.setProcessVersionText("");
        this.view.setProcessDeploymentText("");
        this.view.setCorrelationKeyText("");
        this.view.setParentProcessInstanceIdText("");
        this.view.setActiveTasksListBox("");
        this.view.setStateText("");
        this.view.setCurrentActivitiesListBox("");
        this.view.setProcessDefinitionIdText(process.getProcessId());
        this.view.setProcessVersionText(process.getProcessVersion());
        this.view.setProcessDeploymentText(process.getDeploymentId());
        this.view.setCorrelationKeyText(process.getCorrelationKey());
        if (process.getParentId() > 0L) {
            this.view.setParentProcessInstanceIdText(process.getParentId().toString());
        } else {
            this.view.setParentProcessInstanceIdText(this.constants.No_Parent_Process_Instance());
        }
        this.view.setSlaComplianceText(new SlaStatusConverter().toWidgetValue(process.getSlaCompliance()));
        this.view.setStateText(ProcessInstanceStatusUtils.toWidgetValue(process.getState()));
        if (process.getActiveTasks() != null && !process.getActiveTasks().isEmpty()) {
            SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
            for (UserTaskSummary uts : process.getActiveTasks()) {
                safeHtmlBuilder.appendEscapedLines(uts.getName() + " (" + uts.getStatus() + ")  " + this.constants.Owner() + ": " + uts.getOwner() + " \n");
            }
            this.view.setActiveTasksListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(details -> {
            SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
            for (NodeInstanceSummary nis : details) {
                safeHtmlBuilder.appendEscapedLines(nis.getTimestamp() + ": " + nis.getId() + " - " + nis.getName() + " (" + nis.getType() + ") \n");
            }
            this.view.setCurrentActivitiesListBox(safeHtmlBuilder.toSafeHtml().asString());
        })).getProcessInstanceActiveNodes(process.getProcessInstanceKey());
    }

    public static interface ProcessInstanceDetailsTabView
    extends IsWidget {
        public void setCurrentActivitiesListBox(String var1);

        public void setActiveTasksListBox(String var1);

        public void setProcessDefinitionIdText(String var1);

        public void setStateText(String var1);

        public void setProcessDeploymentText(String var1);

        public void setProcessVersionText(String var1);

        public void setCorrelationKeyText(String var1);

        public void setParentProcessInstanceIdText(String var1);

        public void setSlaComplianceText(String var1);
    }
}

