/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.client.util.SlaStatusConverter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.ProcessInstanceStatusUtils;
import org.uberfire.client.annotations.WorkbenchScreen;

@ApplicationScoped
@WorkbenchScreen(identifier="ProcessInstanceListBasicFiltersScreen")
public class ProcessInstanceListBasicFiltersPresenter
extends BasicFiltersPresenter {
    private Constants constants = Constants.INSTANCE;

    public String getDataSetId() {
        return "jbpmProcessInstances";
    }

    public void loadFilters() {
        this.view.addNumericFilter(this.constants.Id(), this.constants.FilterByProcessInstanceId(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Comparable)f.getValue()))));
        this.view.addTextFilter(this.constants.Initiator(), this.constants.FilterByInitiator(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"user_identity", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Correlation_Key(), this.constants.FilterByCorrelationKey(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"correlationKey", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Process_Instance_Description(), this.constants.FilterByDescription(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"processInstanceDescription", (String)((String)f.getValue()), (boolean)false)));
        HashMap<String, String> errorOptions = new HashMap<String, String>();
        errorOptions.put(String.valueOf(true), this.constants.WithErrors());
        errorOptions.put(String.valueOf(false), this.constants.WithoutErrors());
        Function<String, ColumnFilter> errorFilterGenerator = hasErrors -> Boolean.valueOf(hasErrors) != false ? FilterFactory.greaterThan((String)"errorCount", (Comparable)Integer.valueOf(0)) : FilterFactory.lowerOrEqualsTo((String)"errorCount", (Comparable)Integer.valueOf(0));
        this.view.addMultiSelectFilter(this.constants.Errors(), errorOptions, f -> {
            if (((List)f.getValue()).isEmpty() || ((List)f.getValue()).size() == 2) {
                this.removeSearchFilter((ActiveFilterItem)f, FilterFactory.notNull((String)"errorCount"));
            } else {
                this.addSearchFilter((ActiveFilterItem)f, (ColumnFilter)errorFilterGenerator.apply((String)((List)f.getValue()).get(0)));
            }
        });
        this.view.addMultiSelectFilter(this.constants.State(), ProcessInstanceStatusUtils.getStatesStrMapping(), f -> {
            List values = ((List)f.getValue()).stream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
            ColumnFilter columnFilter = FilterFactory.in((String)"status", values);
            this.addSearchFilterList((ActiveFilterItem)f, columnFilter);
        });
        this.addProcessNameFilter();
        this.addProcessIdFilter();
        this.addDeploymentIdFilter();
        this.addSLAComplianceFilter();
        this.view.addDateRangeFilter(this.constants.Start_Date(), this.constants.Start_Date_Placeholder(), Boolean.valueOf(true), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.between((String)"start_date", (Comparable)((DateRange)f.getValue()).getStartDate(), (Comparable)((DateRange)f.getValue()).getEndDate())));
        this.view.addDateRangeFilter(this.constants.Last_Modification_Date(), this.constants.Last_Modification_Date_Placeholder(), Boolean.valueOf(true), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.between((String)"lastModificationDate", (Comparable)((DateRange)f.getValue()).getStartDate(), (Comparable)((DateRange)f.getValue()).getEndDate())));
    }

    protected void addProcessNameFilter() {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).group("processName")).column("processName")).sort("processName", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.Name(), dataSetLookup, "processName", "processName", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"processName", (Comparable)((Comparable)f.getValue()))));
    }

    protected void addProcessIdFilter() {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).group("processId")).column("processId")).sort("processId", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.Process_Definition_Id(), dataSetLookup, "processId", "processId", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"processId", (Comparable)((Comparable)f.getValue()))));
    }

    protected void addDeploymentIdFilter() {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).group("externalId")).column("externalId")).sort("externalId", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.DeploymentId(), dataSetLookup, "externalId", "externalId", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"externalId", (Comparable)((Comparable)f.getValue()))));
    }

    protected void addSLAComplianceFilter() {
        this.view.addSelectFilter(this.constants.SlaCompliance(), SlaStatusConverter.getSLAComplianceAliasMap(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"slaCompliance", (Comparable)((Comparable)f.getValue()))));
    }

    protected void onActiveFilterAdded(ActiveFilterItem activeFilterItem) {
        if (activeFilterItem.getKey().equals(this.constants.State()) && activeFilterItem.getValue() instanceof List) {
            List values = (List)activeFilterItem.getValue();
            values.forEach(v -> this.view.checkSelectFilter(this.constants.State(), String.valueOf(v)));
        }
    }
}

