/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.signal;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.SuggestBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.instance.signal.ProcessInstanceSignalPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.ValidationState;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="ProcessInstanceSignalViewImpl.html")
public class ProcessInstanceSignalViewImpl
extends Composite
implements ProcessInstanceSignalPresenter.PopupView {
    @Inject
    @DataField
    public Button signalButton;
    @Inject
    @DataField
    public Button clearButton;
    @Inject
    @DataField
    public FormLabel signalRefLabel;
    @Inject
    @DataField
    public FormLabel eventLabel;
    @Inject
    @DataField
    public TextBox eventText;
    @DataField
    public SuggestBox signalRefText;
    @Inject
    @DataField
    public HelpBlock signalRefTextHelpBlock;
    public List<Long> processInstanceIds = new ArrayList<Long>();
    @Inject
    @DataField
    FormGroup signalRefTextGroup;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ProcessInstanceSignalPresenter presenter;
    @Inject
    private Event<NotificationEvent> notification;
    private MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();

    public ProcessInstanceSignalViewImpl() {
        this.signalRefText = new SuggestBox((SuggestOracle)this.oracle);
    }

    public void init(ProcessInstanceSignalPresenter presenter) {
        this.presenter = presenter;
        this.clearButton.setText(this.constants.Clear());
        this.signalButton.setText(this.constants.Signal());
        this.signalRefLabel.setText(this.constants.Signal_Name());
        this.signalRefLabel.setShowRequiredIndicator(true);
        this.eventLabel.setText(this.constants.Signal_Data());
        this.clearFields();
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @EventHandler(value={"signalButton"})
    public void signalButton(ClickEvent e) {
        this.presenter.signalProcessInstances(this.processInstanceIds);
    }

    @EventHandler(value={"clearButton"})
    public void clearButton(ClickEvent e) {
        this.clearFields();
    }

    private void clearFields() {
        this.signalRefText.setValue("");
        this.eventText.setValue((Object)"");
        this.signalRefTextHelpBlock.setText("");
        this.signalRefTextGroup.clearValidationState();
    }

    @Override
    public void addProcessInstanceId(long processInstanceId) {
        this.processInstanceIds.add(processInstanceId);
    }

    @Override
    public String getSignalRefText() {
        return this.signalRefText.getText();
    }

    @Override
    public String getEventText() {
        return this.eventText.getText();
    }

    @Override
    public void setAvailableSignals(Collection<String> signals) {
        this.oracle.addAll(signals);
    }

    @Override
    public void setHelpText(String text) {
        this.signalRefTextGroup.setValidationState(ValidationState.ERROR);
        this.signalRefTextHelpBlock.setText(text);
    }
}

