/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.common.collect.Maps;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataset.DataSetLookup;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.AbstractBasicFiltersPresenterTest;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersView;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListBasicFiltersPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListBasicFiltersPresenterTest
extends AbstractBasicFiltersPresenterTest {
    @InjectMocks
    ProcessInstanceListBasicFiltersPresenter presenter;

    public ProcessInstanceListBasicFiltersPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testLoadFilters() {
        this.presenter.loadFilters();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.getView()});
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addNumericFilter((String)Matchers.eq((Object)Constants.INSTANCE.Id()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.Initiator()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.Correlation_Key()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addTextFilter((String)Matchers.eq((Object)Constants.INSTANCE.Process_Instance_Description()), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addMultiSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.Errors()), (Map)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addMultiSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.State()), (Map)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDataSetSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.Name()), (DataSetLookup)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDataSetSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.Process_Definition_Id()), (DataSetLookup)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDataSetSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.DeploymentId()), (DataSetLookup)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addSelectFilter((String)Matchers.eq((Object)Constants.INSTANCE.SlaCompliance()), (Map)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDateRangeFilter((String)Matchers.eq((Object)Constants.INSTANCE.Start_Date()), (String)Matchers.any(), (Boolean)Matchers.any(), (Consumer)Matchers.any());
        ((BasicFiltersView)inOrder.verify((Object)this.getView())).addDateRangeFilter((String)Matchers.eq((Object)Constants.INSTANCE.Last_Modification_Date()), (String)Matchers.any(), (Boolean)Matchers.any(), (Consumer)Matchers.any());
    }

    @Test
    public void testSlaComplianceFilters() {
        this.presenter.addSLAComplianceFilter();
        org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
        ArgumentCaptor slaDescriptionsCaptors = ArgumentCaptor.forClass(Map.class);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).addSelectFilter(Matchers.anyString(), (Map)slaDescriptionsCaptors.capture(), (Consumer)Matchers.any());
        Map slaDescriptions = (Map)slaDescriptionsCaptors.getValue();
        Map.Entry[] entryArray = new Map.Entry[5];
        entryArray[0] = Maps.immutableEntry((Object)String.valueOf(0), (Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.SlaNA());
        entryArray[1] = Maps.immutableEntry((Object)String.valueOf(1), (Object)commonConstants.SlaPending());
        entryArray[2] = Maps.immutableEntry((Object)String.valueOf(2), (Object)commonConstants.SlaMet());
        entryArray[3] = Maps.immutableEntry((Object)String.valueOf(3), (Object)commonConstants.SlaViolated());
        entryArray[4] = Maps.immutableEntry((Object)String.valueOf(4), (Object)commonConstants.SlaAborted());
        Assertions.assertThat((Map)slaDescriptions).containsExactly(entryArray);
    }

    @Test
    public void onActiveFilterAddedTest() {
        ActiveFilterItem activeFilterItemMock = (ActiveFilterItem)Mockito.mock(ActiveFilterItem.class);
        Mockito.when((Object)activeFilterItemMock.getKey()).thenReturn((Object)Constants.INSTANCE.Name());
        this.presenter.onActiveFilterAdded(activeFilterItemMock);
        ((BasicFiltersView)Mockito.verify((Object)this.getView(), (VerificationMode)Mockito.never())).checkSelectFilter(Matchers.anyString(), Matchers.anyString());
        ((ActiveFilterItem)Mockito.verify((Object)activeFilterItemMock, (VerificationMode)Mockito.never())).getValue();
        Mockito.when((Object)activeFilterItemMock.getKey()).thenReturn((Object)Constants.INSTANCE.State());
        Mockito.when((Object)activeFilterItemMock.getValue()).thenReturn(Arrays.asList(String.valueOf(1), String.valueOf(2)));
        this.presenter.onActiveFilterAdded(activeFilterItemMock);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.State(), String.valueOf(1));
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.State(), String.valueOf(2));
    }

    @Test
    public void testOnActiveFilterAdded() {
        ActiveFilterItem testActiveFilterItem = new ActiveFilterItem(Constants.INSTANCE.State(), "test label", null, Arrays.asList("Active"), null);
        this.presenter.onActiveFilterAdded(testActiveFilterItem);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.State(), "Active");
        ActiveFilterItem activeWithErrorsFilterItem = new ActiveFilterItem("errorCount", "test label", null, Arrays.asList("0"), null);
        this.presenter.onActiveFilterAdded(activeWithErrorsFilterItem);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.Errors(), "0");
        ActiveFilterItem activeWithoutErrorsFilterItem = new ActiveFilterItem("errorCount", "test label", null, Arrays.asList("1"), null);
        this.presenter.onActiveFilterAdded(activeWithoutErrorsFilterItem);
        ((BasicFiltersView)Mockito.verify((Object)this.getView())).checkSelectFilter(Constants.INSTANCE.Errors(), "1");
    }
}

