/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMTokenList;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;

@Dependent
@Templated(value="ProcessInstanceSummaryErrorCountCell.html", stylesheet="ProcessInstanceSummaryErrorCountCell.css")
public class ProcessInstanceSummaryErrorCountCell
extends AbstractCell<ProcessInstanceSummary>
implements IsElement {
    private static final String TOOLTIP_NAME = "pisepc-tooltip";
    private static final String PROCESS_INSTANCE_ATTRIBUTE = "data-jbpm-processInstanceId";
    private static final String ERROR_PRESENT_STYLE = "error-present";
    private static final String LINK_AVAILABLE_STYLE = "link-available";
    @Inject
    @DataField(value="pisepc-tooltip")
    private Anchor tooltip;
    private ProcessInstanceListPresenter viewPresenter;

    public ProcessInstanceSummaryErrorCountCell() {
        super(new String[0]);
    }

    public ProcessInstanceSummaryErrorCountCell init(ProcessInstanceListPresenter viewPresenter) {
        this.viewPresenter = viewPresenter;
        return this;
    }

    public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
        Integer errCount = value != null && value.getErrorCount() != null ? value.getErrorCount() : 0;
        DOMTokenList tooltipClasses = this.tooltip.getClassList();
        this.tooltip.setTextContent(Integer.toString(errCount));
        if (errCount > 0) {
            tooltipClasses.add(ERROR_PRESENT_STYLE);
        } else {
            tooltipClasses.remove(ERROR_PRESENT_STYLE);
        }
        if (this.viewPresenter.getViewErrorsActionCondition().test(value)) {
            this.tooltip.setTitle(Constants.INSTANCE.ErrorCountNumberView(errCount));
            this.tooltip.setAttribute(PROCESS_INSTANCE_ATTRIBUTE, Long.toString(value.getProcessInstanceId()));
            tooltipClasses.add(LINK_AVAILABLE_STYLE);
            this.initTooltipsAsync();
        } else {
            this.tooltip.removeAttribute("title");
            this.tooltip.removeAttribute(PROCESS_INSTANCE_ATTRIBUTE);
            tooltipClasses.remove(LINK_AVAILABLE_STYLE);
        }
        sb.appendHtmlConstant(this.tooltip.getOuterHTML());
    }

    public void openErrorView(String pid) {
        this.viewPresenter.openErrorView(pid);
    }

    private void initTooltipsAsync() {
        Scheduler.get().scheduleDeferred(() -> this.initTooltips(TOOLTIP_NAME, LINK_AVAILABLE_STYLE, PROCESS_INSTANCE_ATTRIBUTE));
    }

    private native void initTooltips(String var1, String var2, String var3);
}

