/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.variables.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.jbpm.workbench.pr.service.ProcessVariablesService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.paging.PageResponse;

@Dependent
public class ProcessVariableListPresenter
extends AbstractListPresenter<ProcessVariableSummary> {
    private Constants constants = Constants.INSTANCE;
    private ProcessVariableListView view;
    private Caller<ProcessVariablesService> variablesServices;
    private Long processInstanceId;
    private String processDefId;
    private String deploymentId;
    private int processInstanceStatus;
    private String serverTemplateId;

    @Inject
    public ProcessVariableListPresenter(ProcessVariableListView view, Caller<ProcessVariablesService> variablesServices) {
        this.view = view;
        this.variablesServices = variablesServices;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.processInstanceId = event.getProcessInstanceId();
        this.processDefId = event.getProcessDefId();
        this.deploymentId = event.getDeploymentId();
        this.processInstanceStatus = event.getProcessInstanceStatus();
        this.serverTemplateId = event.getServerTemplateId();
        this.refreshGrid();
    }

    public int getProcessInstanceStatus() {
        return this.processInstanceStatus;
    }

    public void loadVariableHistory(final ParameterizedCommand<List<ProcessVariableSummary>> callback, String variableName) {
        ((ProcessVariablesService)this.variablesServices.call((RemoteCallback)new RemoteCallback<List<ProcessVariableSummary>>(){

            public void callback(List<ProcessVariableSummary> processVariableSummaries) {
                callback.execute(processVariableSummaries);
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).getVariableHistory(this.serverTemplateId, this.deploymentId, this.processInstanceId, variableName);
    }

    protected ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (this.processInstanceId != null) {
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (this.currentFilter == null) {
                this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() == 0 || columnSortList.get(0).isAscending());
            }
            if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
                this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
                this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
                this.currentFilter.setFilterParams("");
            } else {
                this.currentFilter.setFilterParams("(LOWER(t.name) like '" + this.currentFilter.getParams().get("textSearch") + "' or LOWER(t.description) like '" + this.currentFilter.getParams().get("textSearch") + "') ");
                this.currentFilter.setOffset(Integer.valueOf(0));
                this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
            }
            if (this.currentFilter.getParams() == null) {
                this.currentFilter.setParams(new HashMap());
            }
            this.currentFilter.getParams().put("processInstanceId", String.valueOf(this.processInstanceId));
            this.currentFilter.getParams().put("processDefId", this.processDefId);
            this.currentFilter.getParams().put("deploymentId", this.deploymentId);
            this.currentFilter.getParams().put("processInstanceStatus", this.processInstanceStatus);
            this.currentFilter.getParams().put("serverTemplateId", this.serverTemplateId);
            this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
            this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() == 0 || columnSortList.get(0).isAscending()));
            ((ProcessVariablesService)this.variablesServices.call((RemoteCallback)new RemoteCallback<PageResponse<ProcessVariableSummary>>(){

                public void callback(PageResponse<ProcessVariableSummary> response) {
                    ProcessVariableListPresenter.this.updateDataOnCallback(response);
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ProcessVariableListPresenter.this.view.hideBusyIndicator();
                    ProcessVariableListPresenter.this.view.displayNotification(ProcessVariableListPresenter.this.constants.ErrorRetrievingProcessVariables(throwable.getMessage()));
                    GWT.log((String)throwable.toString());
                    return true;
                }
            })).getData(this.currentFilter);
        }
    }

    public static interface ProcessVariableListView
    extends ListView<ProcessVariableSummary, ProcessVariableListPresenter> {
    }
}

