/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.documents.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.DocumentSummary;
import org.jbpm.workbench.pr.service.ProcessDocumentsService;
import org.uberfire.paging.PageResponse;

@Dependent
public class ProcessDocumentListPresenter
extends AbstractListPresenter<DocumentSummary> {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private ProcessDocumentListView view;
    @Inject
    private Caller<ProcessDocumentsService> documentsServices;
    private String processInstanceId;
    private String processDefId;
    private String deploymentId;
    private String serverTemplateId;

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.processInstanceId = String.valueOf(event.getProcessInstanceId());
        this.processDefId = event.getProcessDefId();
        this.deploymentId = event.getDeploymentId();
        this.serverTemplateId = event.getServerTemplateId();
        this.refreshGrid();
    }

    protected ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (this.processInstanceId != null) {
            ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
            if (this.currentFilter == null) {
                this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() == 0 || columnSortList.get(0).isAscending());
            }
            if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
                this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
                this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
            } else {
                this.currentFilter.setOffset(Integer.valueOf(0));
                this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
            }
            if (this.currentFilter.getParams() == null) {
                this.currentFilter.setParams(new HashMap());
            }
            this.currentFilter.getParams().put("processInstanceId", this.processInstanceId);
            this.currentFilter.getParams().put("processDefId", this.processDefId);
            this.currentFilter.getParams().put("deploymentId", this.deploymentId);
            this.currentFilter.getParams().put("serverTemplateId", this.serverTemplateId);
            this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
            this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() == 0 || columnSortList.get(0).isAscending()));
            ((ProcessDocumentsService)this.documentsServices.call((RemoteCallback)new RemoteCallback<PageResponse<DocumentSummary>>(){

                public void callback(PageResponse<DocumentSummary> response) {
                    ProcessDocumentListPresenter.this.updateDataOnCallback(response);
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ProcessDocumentListPresenter.this.view.hideBusyIndicator();
                    ProcessDocumentListPresenter.this.view.displayNotification(ProcessDocumentListPresenter.this.constants.ErrorRetrievingProcessDocuments(throwable.getMessage()));
                    GWT.log((String)throwable.toString());
                    return true;
                }
            })).getData(this.currentFilter);
        }
    }

    public static interface ProcessDocumentListView
    extends ListView<DocumentSummary, ProcessDocumentListPresenter> {
    }
}

