/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.diagram;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetViewImpl;
import org.jbpm.workbench.pr.client.editors.diagram.ZoomControlView;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.widgets.D3;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDiagramWidgetViewTest {
    @InjectMocks
    private ProcessDiagramWidgetViewImpl view;
    @Mock(name="processDiagramDiv")
    private HTMLDivElement processDiagramDiv;
    @Mock
    private HTMLDivElement alertDiv;
    @Mock
    private ZoomControlView zoomControlView;
    @Mock
    private D3 d3Mock;
    @Mock
    private D3.Selection svgSelect;
    @Mock
    private D3.Zoom zoomMock;
    @Mock
    private D3.Transform transformMock;
    double svgWidth = 200.0;
    double svgHeight = 100.0;

    @Before
    public void setup() {
        this.view.setD3Component(this.d3Mock);
        Mockito.when((Object)this.d3Mock.select(Matchers.anyString())).thenReturn((Object)this.svgSelect);
        Mockito.when((Object)this.d3Mock.zoom()).thenReturn((Object)this.zoomMock);
        Mockito.when((Object)this.svgSelect.attr("viewBox")).thenReturn((Object)("0 0 " + this.svgWidth + " " + this.svgHeight));
        D3.Event event = (D3.Event)Mockito.mock(D3.Event.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{D3.ZoomEvent.class}));
        D3.ZoomEvent zoomEvent = (D3.ZoomEvent)event;
        Mockito.when((Object)this.d3Mock.getEvent()).thenReturn((Object)event);
        Mockito.when((Object)zoomEvent.getTransform()).thenReturn((Object)this.transformMock);
    }

    private void testD3ZoomInitialization() {
        String svgContent = "svgContent";
        this.view.displayImage(svgContent);
        double[] scaleExtent = new double[]{0.1, 3.0};
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).scaleExtent((double[])Matchers.eq((Object)scaleExtent));
    }

    @Test
    public void testZoomCall() {
        double k = 1.2;
        this.testD3ZoomInitialization();
        ArgumentCaptor captor = ArgumentCaptor.forClass(D3.CallbackFunction.class);
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).on(Matchers.anyString(), (D3.CallbackFunction)captor.capture());
        Mockito.when((Object)this.transformMock.getK()).thenReturn((Object)k);
        ((D3.CallbackFunction)captor.getValue()).execute();
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setX((this.svgWidth * k - this.svgWidth) / 2.0);
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setY((this.svgHeight * k - this.svgHeight) / 2.0);
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = 0.0;
        translateExtent[0][1] = 0.0;
        translateExtent[1][0] = this.svgWidth * k;
        translateExtent[1][1] = this.svgHeight * k;
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).translateExtent((double[][])Matchers.eq((Object)translateExtent));
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disableMinusButton(false);
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disablePlusButton(false);
    }

    @Test
    public void test100ZoomCalls() {
        this.testD3ZoomInitialization();
        ArgumentCaptor captor = ArgumentCaptor.forClass(D3.CallbackFunction.class);
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).on(Matchers.anyString(), (D3.CallbackFunction)captor.capture());
        Mockito.when((Object)this.transformMock.getK()).thenReturn((Object)1.0);
        ((D3.CallbackFunction)captor.getValue()).execute();
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setX(0.0);
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setY(0.0);
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = 0.0;
        translateExtent[0][1] = 0.0;
        translateExtent[1][0] = 200.0;
        translateExtent[1][1] = 100.0;
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).translateExtent((double[][])Matchers.eq((Object)translateExtent));
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disableMinusButton(false);
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disablePlusButton(false);
    }

    @Test
    public void test50ZoomCalls() {
        this.testD3ZoomInitialization();
        ArgumentCaptor captor = ArgumentCaptor.forClass(D3.CallbackFunction.class);
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).on(Matchers.anyString(), (D3.CallbackFunction)captor.capture());
        Mockito.when((Object)this.transformMock.getK()).thenReturn((Object)0.5);
        ((D3.CallbackFunction)captor.getValue()).execute();
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setX(-50.0);
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setY(-25.0);
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = 0.0;
        translateExtent[0][1] = 0.0;
        translateExtent[1][0] = 100.0;
        translateExtent[1][1] = 50.0;
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).translateExtent((double[][])Matchers.eq((Object)translateExtent));
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disableMinusButton(false);
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disablePlusButton(false);
    }

    @Test
    public void test10ZoomCalls() {
        this.testD3ZoomInitialization();
        ArgumentCaptor captor = ArgumentCaptor.forClass(D3.CallbackFunction.class);
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).on(Matchers.anyString(), (D3.CallbackFunction)captor.capture());
        Mockito.when((Object)this.transformMock.getK()).thenReturn((Object)0.1);
        ((D3.CallbackFunction)captor.getValue()).execute();
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setX(-90.0);
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setY(-45.0);
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = 0.0;
        translateExtent[0][1] = 0.0;
        translateExtent[1][0] = 20.0;
        translateExtent[1][1] = 10.0;
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).translateExtent((double[][])Matchers.eq((Object)translateExtent));
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disableMinusButton(true);
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disablePlusButton(false);
    }

    @Test
    public void test300ZoomCalls() {
        this.testD3ZoomInitialization();
        ArgumentCaptor captor = ArgumentCaptor.forClass(D3.CallbackFunction.class);
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).on(Matchers.anyString(), (D3.CallbackFunction)captor.capture());
        Mockito.when((Object)this.transformMock.getK()).thenReturn((Object)3.0);
        ((D3.CallbackFunction)captor.getValue()).execute();
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setX(200.0);
        ((D3.Transform)Mockito.verify((Object)this.transformMock)).setY(100.0);
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = 0.0;
        translateExtent[0][1] = 0.0;
        translateExtent[1][0] = 600.0;
        translateExtent[1][1] = 300.0;
        ((D3.Zoom)Mockito.verify((Object)this.zoomMock)).translateExtent((double[][])Matchers.eq((Object)translateExtent));
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disableMinusButton(false);
        ((ZoomControlView)Mockito.verify((Object)this.zoomControlView)).disablePlusButton(true);
    }
}

