/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.pr.client.editors.instance.ProcessInstanceSummaryAware;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstanceRescheduleView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDiagramExpandEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceDiagramSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.model.TimerSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.kie.workbench.common.widgets.client.popups.alert.AlertPopupView;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ProcessInstanceDiagramPresenter
implements ProcessInstanceSummaryAware {
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processService;
    private List<ProcessNodeSummary> processNodes;
    private List<NodeInstanceSummary> nodeInstances;
    private List<TimerInstanceSummary> timerInstances;
    private List<TimerSummary> timers;
    private ProcessInstanceSummary processInstance;
    private boolean forLog;
    @Inject
    private TimerInstanceRescheduleView rescheduleView;
    @Inject
    private ProcessInstanceDiagramView view;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceEvent;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    protected ManagePreferences preferences;
    private ConfirmPopup confirmPopup;
    private AlertPopupView alertPopup;

    @PostConstruct
    public void init() {
        this.view.setOnProcessNodeSelectedCallback((Callback<String>)((Callback)id -> this.onDiagramNodeSelected((String)id)));
        this.view.setOnDiagramNodeSelectionCallback((Callback<String>)((Callback)id -> this.onDiagramNodeSelected((String)id)));
        this.view.setOnDiagramNodeSelectionDoubleClick((Callback<String>)((Callback)id -> this.onDiagramNodeSelectedByDoubleClick((String)id)));
        this.preferences.load();
    }

    @Inject
    protected void setConfirmPopup(ConfirmPopup confirmPopup) {
        this.confirmPopup = confirmPopup;
    }

    @Inject
    protected void setAlertPopup(AlertPopupView alertPopup) {
        this.alertPopup = alertPopup;
    }

    @Override
    public void setProcessInstance(ProcessInstanceSummary processInstance) {
        this.view.showBusyIndicator(this.constants.Loading());
        this.processInstance = processInstance;
        this.processNodes = Collections.emptyList();
        this.view.setProcessNodes(this.processNodes);
        this.nodeInstances = Collections.emptyList();
        this.view.setNodeInstances(this.nodeInstances);
        this.timerInstances = Collections.emptyList();
        this.view.setTimerInstances(this.timerInstances);
        this.timers = Collections.emptyList();
        this.view.setValue(new ProcessNodeSummary());
        this.loadProcessInstanceDetails();
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.forLog = event.isForLog();
    }

    protected void loadProcessInstanceDetails() {
        ((ProcessRuntimeDataService)this.processService.call(summary -> {
            this.displayImage(summary.getSvgContent(), this.processInstance.getDeploymentId());
            this.processNodes = summary.getProcessDefinition().getNodes().stream().sorted(Comparator.comparing(ProcessNodeSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            this.processNodes.stream().filter(this::isProcessNodeTypeTriggerAllowed).forEach(pn -> pn.addCallback(this.constants.Trigger(), () -> this.onProcessNodeTrigger((ProcessNodeSummary)pn)));
            this.view.setProcessNodes(this.processNodes);
            this.view.setShowOrHideParentAndSubProcessPanelCommand(() -> this.showOrHideParentAndSubProcessPanel(summary.getParentProcessInstanceSummary(), summary.getSubProcessInstances()));
            this.nodeInstances = summary.getNodeInstances().stream().sorted(Comparator.comparing(NodeInstanceSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            this.nodeInstances.forEach(ni -> {
                ni.setDescription((ni.isCompleted() != false ? this.constants.Completed() : this.constants.Started()) + " " + DateUtils.getPrettyTime((Date)ni.getTimestamp()));
                if (!ni.isCompleted().booleanValue()) {
                    ni.addCallback(this.constants.Cancel(), () -> this.onNodeInstanceCancel((NodeInstanceSummary)ni));
                    ni.addCallback(this.constants.ReTrigger(), () -> this.onNodeInstanceReTrigger((NodeInstanceSummary)ni));
                }
            });
            Map<String, Long> badges = this.nodeInstances.stream().collect(Collectors.groupingBy(NodeInstanceSummary::getNodeUniqueName, Collectors.counting()));
            this.view.setNodeBadges(badges);
            this.view.setNodeInstances(this.nodeInstances);
            this.view.showOrHideParentAndSubProcessPanelTriggered();
            this.view.setSubProcessInstances(summary.getSubProcessInstances());
            this.view.setParentProcessInstance(summary.getParentProcessInstanceSummary());
            this.view.setParentSelectedCommand(() -> this.listenParentProcessInstanceSelected());
            this.timerInstances = summary.getTimerInstances().stream().sorted(Comparator.comparing(TimerInstanceSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            this.timerInstances.forEach(ti -> {
                ti.setDescription(this.constants.NextExecution() + " " + DateUtils.getPrettyTime((Date)ti.getNextFireTime()));
                ti.addCallback(this.constants.Reschedule(), () -> {
                    this.rescheduleView.setOnReschedule((Callback<TimerInstanceSummary>)((Callback)timer -> this.onTimerInstanceReschedule((TimerInstanceSummary)timer)));
                    this.rescheduleView.setValue((TimerInstanceSummary)ti);
                    this.rescheduleView.show();
                });
            });
            this.view.setTimerInstances(this.timerInstances);
            this.view.setShowOrHideNodeActionsCommand(() -> this.showOrHideNodeActions(this.forLog, this.processInstance));
            this.timers = summary.getProcessDefinition().getTimers().stream().collect(Collectors.toList());
            this.view.showOrHideNodeActionsTriggered();
            this.expandDiagram(this.processInstance, (ProcessInstanceDiagramSummary)summary);
            this.view.onShow();
        })).getProcessInstanceDiagramSummary(this.processInstance.getProcessInstanceKey(), this.preferences.getProcessInstanceDiagramCompletedNodeColor(), this.preferences.getProcessInstanceDiagramCompletedNodeBorderColor(), this.preferences.getProcessInstanceDiagramActiveNodeBorderColor());
    }

    protected void expandDiagram(ProcessInstanceSummary processInstance, ProcessInstanceDiagramSummary summary) {
        if ((this.forLog || processInstance.getState() != 1) && summary.getSubProcessInstances().isEmpty() && summary.getParentProcessInstanceSummary() == null) {
            this.view.expandDiagram();
            this.view.disableExpandAnchor();
        }
    }

    protected void showOrHideParentAndSubProcessPanel(ProcessInstanceSummary parentProcessInstance, List<ProcessInstanceSummary> subProcessInstances) {
        if (subProcessInstances.isEmpty() && parentProcessInstance == null) {
            this.view.hideParentAndSubProcessPanel();
        } else {
            this.view.showParentAndSubProcessPanel();
        }
    }

    public void displayImage(String svgContent, String containerId) {
        if (svgContent == null || svgContent.isEmpty()) {
            this.view.displayMessage(this.constants.Process_Diagram_Not_FoundContainerShouldBeAvailable(containerId));
        } else {
            this.view.displayImage(svgContent);
        }
        this.view.hideBusyIndicator();
    }

    public void onDiagramNodeSelected(String nodeId) {
        if (nodeId == null) {
            this.view.setValue(new ProcessNodeSummary());
            this.view.setNodeInstances(this.nodeInstances);
            this.view.setTimerInstances(this.timerInstances);
        } else {
            this.view.setValue(this.processNodes.stream().filter(node -> node.getUniqueId().equals(nodeId)).findFirst().orElseGet(() -> new ProcessNodeSummary()));
            this.view.setNodeInstances(this.nodeInstances.stream().filter(node -> node.getNodeUniqueName().equals(nodeId)).collect(Collectors.toList()));
            this.view.setTimerInstances(this.getTimerInstanceForNode(nodeId));
        }
    }

    protected void onDiagramNodeSelectedByDoubleClick(String nodeId) {
        List<NodeInstanceSummary> nodeInstanceSummaries = this.nodeInstances.stream().filter(node -> node.getNodeUniqueName().equals(nodeId)).collect(Collectors.toList());
        List nodeInstancesSubProcess = nodeInstanceSummaries.stream().filter(node -> node.getType().equals("SubProcessNode")).collect(Collectors.toList());
        if (nodeInstancesSubProcess.size() == 1) {
            this.openNavigationConfirmPopup((NodeInstanceSummary)nodeInstancesSubProcess.get(0));
        }
        if (nodeInstancesSubProcess.size() > 1) {
            this.alertPopup.alert(this.constants.AlertPopupTitle(), this.constants.AlertPopupMessage());
        }
        if (nodeInstancesSubProcess.size() < 1) {
            this.view.setNodeInstances(nodeInstanceSummaries);
            this.view.setTimerInstances(this.getTimerInstanceForNode(nodeId));
        }
        this.view.setValue(this.processNodes.stream().filter(node -> node.getUniqueId().equals(nodeId)).findFirst().orElseGet(() -> new ProcessNodeSummary()));
    }

    protected void openNavigationConfirmPopup(NodeInstanceSummary nodeInstance) {
        this.confirmPopup.show(this.constants.NavigationConfirmTitle(), this.constants.NavigationConfirmOkButtonText(), this.constants.NavigationConfirmMessage(), () -> {
            ProcessInstanceKey processInstanceKey = new ProcessInstanceKey(this.processInstance.getProcessInstanceKey().getServerTemplateId(), this.processInstance.getProcessInstanceKey().getDeploymentId(), nodeInstance.getReferenceId());
            this.processInstanceEvent.fire((Object)new ProcessInstanceSelectionEvent(processInstanceKey, this.forLog, true));
        });
    }

    protected List<TimerInstanceSummary> getTimerInstanceForNode(String nodeId) {
        Optional<TimerSummary> summary = this.timers.stream().filter(timer -> timer.getUniqueId().equals(nodeId)).findFirst();
        if (summary.isPresent()) {
            return this.timerInstances.stream().filter(instance -> instance.getTimerId().equals(((TimerSummary)summary.get()).getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Boolean isProcessNodeTypeTriggerAllowed(ProcessNodeSummary nodeSummary) {
        if (nodeSummary == null || nodeSummary.getType() == null) {
            return false;
        }
        if ("StartNode".equals(nodeSummary.getType()) || "Join".equals(nodeSummary.getType())) {
            return false;
        }
        return true;
    }

    protected ProcessNodeSummary getProcessNodeSummary(Long nodeId) {
        return this.processNodes.stream().filter(node -> ((Long)node.getId()).equals(nodeId)).findFirst().get();
    }

    public void onProcessNodeTrigger(ProcessNodeSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeTriggered(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.view.setValue(new ProcessNodeSummary());
            this.refreshDetails();
        })).triggerProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    protected void refreshDetails() {
        this.processInstanceEvent.fire((Object)new ProcessInstanceSelectionEvent(this.processInstance.getProcessInstanceKey(), this.forLog));
    }

    public void listenParentProcessInstanceSelected() {
        this.processInstanceEvent.fire((Object)new ProcessInstanceSelectionEvent(new ProcessInstanceKey(this.processInstance.getServerTemplateId(), this.processInstance.getDeploymentId(), this.processInstance.getParentId()), false, true));
    }

    public void onNodeInstanceReTrigger(NodeInstanceSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeInstanceReTriggered(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).reTriggerProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    public void onNodeInstanceCancel(NodeInstanceSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeInstanceCancelled(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).cancelProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    public void onTimerInstanceReschedule(TimerInstanceSummary summary) {
        ((ProcessRuntimeDataService)this.processService.call(Void -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.TimerInstanceRescheduled(summary.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).rescheduleTimerInstance(this.processInstance.getProcessInstanceKey(), summary);
    }

    public void onShow() {
        this.view.onShow();
    }

    @WorkbenchPartTitle
    public String getName() {
        return this.constants.Diagram();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    @Inject
    public void setProcessService(Caller<ProcessRuntimeDataService> processService) {
        this.processService = processService;
    }

    public void onProcessDiagramExpandEvent(@Observes ProcessDiagramExpandEvent event) {
        if (event.isExpand()) {
            this.view.hideNodeActions();
            this.view.hideParentAndSubProcessPanel();
        } else {
            this.view.showOrHideNodeActionsTriggered();
            this.view.showOrHideParentAndSubProcessPanelTriggered();
        }
    }

    protected void showOrHideNodeActions(boolean forLog, ProcessInstanceSummary processInstance) {
        if (forLog || processInstance.getState() != 1) {
            this.view.hideNodeActions();
        } else {
            this.view.showNodeActions();
        }
    }
}

