/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details.multi;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsViewImpl;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsPresenterTest {
    private static final int ACTIVE_STATE = 1;
    private static final String PROCESS_VERSION = "1.0";
    private static final String PROCESS_ID = "evaluation";
    private static final String PROCESS_INSTANCE_ID = "3";
    private static final String SERVER_TEMPLATE_ID = "testTemplate";
    private static final String DEPLOYMENT_ID = "evaluation_1.0.0-SNAPSHOT";
    private HTML htmlMock;
    private UserTaskSummary userTaskSummary;
    private NodeInstanceSummary nodeInstanceSummary;
    private ProcessInstanceSummary processInstanceSummary;
    private ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView viewMock;
    @Mock
    private ProcessRuntimeDataService processRuntimeDataServiceMock;
    @InjectMocks
    private ProcessInstanceDetailsPresenter presenter;

    @Before
    public void setUp() {
        this.htmlMock = (HTML)Mockito.mock(HTML.class);
        this.viewMock = (ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.mock(ProcessInstanceDetailsViewImpl.class, invocationOnMock -> this.htmlMock);
        this.presenter.setView(this.viewMock);
        this.presenter.setProcessRuntimeDataService((Caller)new CallerMock((Object)this.processRuntimeDataServiceMock));
        this.nodeInstanceSummary = this.getNodeInstanceSummary();
        Mockito.when((Object)this.processRuntimeDataServiceMock.getProcessInstanceActiveNodes(SERVER_TEMPLATE_ID, DEPLOYMENT_ID, Long.valueOf(Long.parseLong(PROCESS_INSTANCE_ID)))).thenReturn(Collections.singletonList(this.nodeInstanceSummary));
        this.processInstanceSummary = this.getProcessInstanceSummary();
        Mockito.when((Object)this.processRuntimeDataServiceMock.getProcessInstance((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (ProcessInstanceKey)Mockito.any(ProcessInstanceKey.class))).thenReturn((Object)this.processInstanceSummary);
    }

    @Test
    public void setProcessInstanceDetailsTest() {
        this.presenter.refreshProcessInstanceDataRemote(DEPLOYMENT_ID, PROCESS_INSTANCE_ID, SERVER_TEMPLATE_ID);
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(this.processInstanceSummary.getProcessId());
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(Constants.INSTANCE.Active());
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(this.processInstanceSummary.getDeploymentId());
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(this.processInstanceSummary.getProcessVersion());
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(this.processInstanceSummary.getCorrelationKey());
        ((HTML)Mockito.verify((Object)this.htmlMock)).setText(Constants.INSTANCE.No_Parent_Process_Instance());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((HTML)Mockito.verify((Object)this.htmlMock, (VerificationMode)Mockito.times((int)2))).setHTML((SafeHtml)argumentCaptor.capture());
        List safeHtmlList = argumentCaptor.getAllValues();
        ((ListAssert)Assertions.assertThat((List)safeHtmlList).as("Active user tasks & Current Activities are set", new Object[0])).hasSize(2);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((SafeHtml)safeHtmlList.get(0)).asString()).as("Active user tasks", new Object[0])).contains(new CharSequence[]{this.userTaskSummary.getName(), this.userTaskSummary.getStatus(), this.userTaskSummary.getOwner()});
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((SafeHtml)safeHtmlList.get(1)).asString()).as("Current Activities", new Object[0])).contains(new CharSequence[]{this.nodeInstanceSummary.getTimestamp(), String.valueOf(this.nodeInstanceSummary.getId()), this.nodeInstanceSummary.getNodeName(), this.nodeInstanceSummary.getType()});
    }

    private NodeInstanceSummary getNodeInstanceSummary() {
        NodeInstanceSummary nodeInstanceSummary = new NodeInstanceSummary();
        nodeInstanceSummary.setTimestamp("Fri Oct 27 17:47:07 CEST 2017");
        nodeInstanceSummary.setId(1L);
        nodeInstanceSummary.setNodeName("Self Evaluation");
        nodeInstanceSummary.setType("HumanTaskNode");
        return nodeInstanceSummary;
    }

    private ProcessInstanceSummary getProcessInstanceSummary() {
        ProcessInstanceSummary processInstanceSummary = new ProcessInstanceSummary();
        processInstanceSummary.setProcessId(PROCESS_ID);
        processInstanceSummary.setState(Integer.valueOf(1));
        processInstanceSummary.setDeploymentId(DEPLOYMENT_ID);
        processInstanceSummary.setProcessVersion(PROCESS_VERSION);
        processInstanceSummary.setCorrelationKey(PROCESS_INSTANCE_ID);
        processInstanceSummary.setParentId(Long.valueOf(0L));
        processInstanceSummary.setActiveTasks(Collections.singletonList(this.getUserTaskSummary()));
        return processInstanceSummary;
    }

    private UserTaskSummary getUserTaskSummary() {
        this.userTaskSummary = new UserTaskSummary(Long.valueOf(1L), "Self Evaluation", "testuser", "Reserved");
        return this.userTaskSummary;
    }
}

