/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListBasicFiltersPresenter;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListFilterSettingsManager;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewCaseInstanceEvent;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessDefinitionListScreen")
public class ProcessDefinitionListPresenter
extends AbstractMultiGridPresenter<ProcessSummary, ProcessDefinitionListView> {
    @Inject
    PopupFormDisplayerView formDisplayPopUp;
    @Inject
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    @Inject
    private DefaultWorkbenchErrorCallback errorCallback;
    protected ProcessDefinitionListBasicFiltersPresenter processDefinitionListBasicFiltersPresenter;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelected;
    private Constants constants = Constants.INSTANCE;
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    private final List<ProcessSummary> myProcessDefinitionsFromDataSet = new ArrayList<ProcessSummary>();

    @Inject
    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @Inject
    public void setProcessDefinitionListBasicFiltersPresenter(ProcessDefinitionListBasicFiltersPresenter processDefinitionListBasicFiltersPresenter) {
        this.processDefinitionListBasicFiltersPresenter = processDefinitionListBasicFiltersPresenter;
    }

    public void setupActiveSearchFilters() {
    }

    public boolean existActiveSearchFilters() {
        return false;
    }

    protected void selectSummaryItem(ProcessSummary processSummary) {
        this.setupDetailBreadcrumb(this.constants.ProcessDefinitionBreadcrumb(processSummary.getName()));
        this.placeManager.goTo("ProcessDefinitionDetailsScreen");
        this.fireProcessDefSelectionEvent(processSummary);
    }

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), detailLabel, "ProcessDefinitionDetailsScreen");
    }

    public void openGenericForm(String processDefId, String deploymentId, String processDefName, boolean isDynamic) {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.getSelectedServerTemplate(), deploymentId, processDefId, processDefName), processDefName, isDynamic);
        this.formDisplayPopUp.setTitle(processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    @Inject
    public void setFilterSettingsManager(ProcessDefinitionListFilterSettingsManager filterSettingsManager) {
        super.setFilterSettingsManager((FilterSettingsManager)filterSettingsManager);
    }

    protected DataSetReadyCallback getDataSetReadyCallback(Integer startRange, FilterSettings tableSettings) {
        return ((ErrorHandlerBuilder)this.errorHandlerBuilder.get()).withUUID(tableSettings.getUUID()).withDataSetCallback(dataSet -> {
            if (dataSet != null && this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                this.myProcessDefinitionsFromDataSet.clear();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    this.myProcessDefinitionsFromDataSet.add(this.createProcessSummaryFromDataSet((DataSet)dataSet, i));
                }
                boolean lastPage = false;
                if (dataSet.getRowCount() < ((ProcessDefinitionListView)this.view).getListGrid().getPageSize()) {
                    lastPage = true;
                }
                this.updateDataOnCallback(this.myProcessDefinitionsFromDataSet, startRange, startRange + this.myProcessDefinitionsFromDataSet.size(), lastPage);
            }
            ((ProcessDefinitionListView)this.view).hideBusyIndicator();
        }).withEmptyResultsCallback(() -> this.setEmptyResults());
    }

    private ProcessSummary createProcessSummaryFromDataSet(DataSet dataSet, int index) {
        return new ProcessSummary(DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ProcessDefId", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ProcessName", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"Project", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ProcessVersion", (int)index), Boolean.valueOf(DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"Dynamic", (int)index)).booleanValue());
    }

    boolean onRuntimeDataServiceError(Throwable throwable) {
        this.setEmptyResults();
        this.errorCallback.error(throwable);
        return false;
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build());
    }

    private void fireProcessDefSelectionEvent(ProcessSummary processSummary) {
        this.processDefSelected.fire((Object)new ProcessDefSelectionEvent(processSummary.getProcessDefId(), processSummary.getDeploymentId(), this.getSelectedServerTemplate(), processSummary.getProcessDefName(), processSummary.isDynamic()));
    }

    public void refreshNewProcessInstance(@Observes NewProcessInstanceEvent newProcessInstance) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), this.constants.ProcessInstanceBreadcrumb(newProcessInstance.getNewProcessInstanceId()), "ProcessInstanceDetailsScreen");
        this.placeManager.goTo("ProcessInstanceDetailsScreen");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getServerTemplateId(), newProcessInstance.getDeploymentId(), newProcessInstance.getNewProcessInstanceId(), false));
    }

    public void refreshNewCaseInstance(@Observes NewCaseInstanceEvent newCaseInstance) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(newProcessInstance -> {
            this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), this.constants.ProcessInstanceBreadcrumb((Long)newProcessInstance.getId()), "ProcessInstanceDetailsScreen");
            this.placeManager.goTo("ProcessInstanceDetailsScreen");
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getServerTemplateId(), newProcessInstance.getDeploymentId(), (Long)newProcessInstance.getId(), false));
        }, (message, throwable) -> this.onRuntimeDataServiceError(throwable))).getProcessInstanceByCorrelationKey(newCaseInstance.getServerTemplateId(), newCaseInstance.getNewCaseId());
    }

    public Predicate<ProcessSummary> getViewProcessInstanceActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ProcessInstances");
    }

    public Predicate<ProcessSummary> getStartCondition() {
        return processSummary -> !processSummary.isDynamic() || processSummary.isDynamic() && processSummary.isDynamicFormsEnabled();
    }

    public void viewProcessInstances(String processDefId) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("ProcessInstances");
        placeRequestImpl.addParameter("processDefinitionId", processDefId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public boolean isUserAuthorizedForPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public static interface ProcessDefinitionListView
    extends MultiGridView<ProcessSummary, ProcessDefinitionListPresenter> {
    }
}

