/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.common.collect.Maps;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramPresenter;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstanceRescheduleView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceDiagramSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.model.TimerSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.workbench.common.widgets.client.popups.alert.AlertPopupView;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDiagramPresenterTest {
    @Mock
    ProcessRuntimeDataService processService;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<ProcessInstanceSelectionEvent> processInstanceEvent;
    @Mock
    ProcessInstanceDiagramView view;
    @Mock
    protected ManagePreferences preferences;
    @Mock
    ConfirmPopup confirmPopup;
    @Mock
    AlertPopupView alertPopup;
    @Inject
    private TimerInstanceRescheduleView rescheduleView;
    @InjectMocks
    ProcessInstanceDiagramPresenter presenter;
    private String completeNodeColor = "#888888";
    private String completeNodeBorderColor = "#888887";
    private String activeNodeBorderColor = "#888886";

    @Before
    public void setup() {
        this.presenter.setProcessService((Caller)new CallerMock((Object)this.processService));
        Mockito.when((Object)this.preferences.getProcessInstanceDiagramCompletedNodeColor()).thenReturn((Object)this.completeNodeColor);
        Mockito.when((Object)this.preferences.getProcessInstanceDiagramCompletedNodeBorderColor()).thenReturn((Object)this.completeNodeBorderColor);
        Mockito.when((Object)this.preferences.getProcessInstanceDiagramActiveNodeBorderColor()).thenReturn((Object)this.activeNodeBorderColor);
    }

    @Test
    public void testEmptyProcessInstanceDiagram() {
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.any(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)ProcessInstanceDiagramSummary.builder().withProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build()).withNodeInstances(Collections.emptyList()).build(), (Object[])new ProcessInstanceDiagramSummary[]{ProcessInstanceDiagramSummary.builder().withProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build()).withNodeInstances(Collections.emptyList()).withSvgContent("").build()});
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
    }

    @Test
    public void testProcessInstanceDiagram() {
        String svgContent = "<svg></svg>";
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.any(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)ProcessInstanceDiagramSummary.builder().withProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build()).withNodeInstances(Collections.emptyList()).withSvgContent("<svg></svg>").build(), (Object[])new ProcessInstanceDiagramSummary[]{ProcessInstanceDiagramSummary.builder().withProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build()).withNodeInstances(Collections.emptyList()).build()});
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).displayImage("<svg></svg>");
    }

    @Test
    public void testOnProcessInstanceSelectionEvent() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        String svgContent = "<svg></svg>";
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(1L), " ", "StartNode", "_1"), new ProcessNodeSummary(Long.valueOf(2L), "task-name", "HumanTask", "_2"), new ProcessNodeSummary(Long.valueOf(3L), " ", "Split", "_3"));
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_2").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        List<TimerInstanceSummary> timerInstances = Arrays.asList(TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withName("t2").build(), TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withName("t1").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setSvgContent(svgContent);
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.emptyList()).build());
        summary.setNodeInstances(nodeInstances);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(timerInstances);
        this.presenter.setProcessInstance(processInstance);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showBusyIndicator((String)Matchers.any());
        ArgumentCaptor nodesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setProcessNodes((List)nodesCaptor.capture());
        Assertions.assertThat((List)((List)nodesCaptor.getAllValues().get(0))).isEmpty();
        List viewNodes = (List)nodesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewNodes).hasSameSizeAs(nodes);
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getLabel()).isEqualTo("Split-3");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getName()).isEqualTo("Split");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getType()).isEqualTo("Split");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getUniqueId()).isEqualTo("_3");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(0)).getCallbacks()).hasSize(1);
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getLabel()).isEqualTo("StartNode-1");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getName()).isEqualTo("StartNode");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getType()).isEqualTo("StartNode");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getUniqueId()).isEqualTo("_1");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(1)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getLabel()).isEqualTo("task-name-2");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getName()).isEqualTo("task-name");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getType()).isEqualTo("HumanTask");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getUniqueId()).isEqualTo("_2");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(2)).getCallbacks()).hasSize(1);
        ArgumentCaptor nodeInstancesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setNodeInstances((List)nodeInstancesCaptor.capture());
        Assertions.assertThat((List)((List)nodeInstancesCaptor.getAllValues().get(0))).isEmpty();
        List viewNodeInstances = (List)nodeInstancesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewNodeInstances).hasSameSizeAs(nodeInstances);
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getLabel()).isEqualTo("End-4");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getName()).isEqualTo("End");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getType()).isEqualTo("End");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getDescription()).startsWith((CharSequence)"Completed");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(0)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getLabel()).isEqualTo("name-1-1");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getName()).isEqualTo("name-1");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getType()).isEqualTo("HumanTask");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getDescription()).startsWith((CharSequence)"Started");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(1)).getCallbacks()).hasSize(2);
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getLabel()).isEqualTo("name-3-3");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getName()).isEqualTo("name-3");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getType()).isEqualTo("HumanTask");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getDescription()).startsWith((CharSequence)"Completed");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(2)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getLabel()).isEqualTo("Split-2");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getName()).isEqualTo("Split");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getType()).isEqualTo("Split");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getDescription()).startsWith((CharSequence)"Started");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(3)).getCallbacks()).hasSize(2);
        ArgumentCaptor timerInstancesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setTimerInstances((List)timerInstancesCaptor.capture());
        Assertions.assertThat((List)((List)timerInstancesCaptor.getAllValues().get(0))).isEmpty();
        List viewTimerInstances = (List)timerInstancesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewTimerInstances).hasSameSizeAs(timerInstances);
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getLabel()).isEqualTo("t1-1");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getName()).isEqualTo("t1");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getDescription()).startsWith((CharSequence)"NextExecution");
        Assertions.assertThat((List)((TimerInstanceSummary)viewTimerInstances.get(0)).getCallbacks()).hasSize(1);
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getLabel()).isEqualTo("t2-2");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getName()).isEqualTo("t2");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getDescription()).startsWith((CharSequence)"NextExecution");
        Assertions.assertThat((List)((TimerInstanceSummary)viewTimerInstances.get(1)).getCallbacks()).hasSize(1);
        ArgumentCaptor badgesInstancesCaptor = ArgumentCaptor.forClass(Map.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setNodeBadges((Map)badgesInstancesCaptor.capture());
        Map badges = (Map)badgesInstancesCaptor.getValue();
        Assertions.assertThat((Map)badges).containsExactly(new Map.Entry[]{Maps.immutableEntry((Object)"_1", (Object)1L), Maps.immutableEntry((Object)"_2", (Object)1L), Maps.immutableEntry((Object)"_3", (Object)1L), Maps.immutableEntry((Object)"_4", (Object)1L)});
    }

    @Test
    public void testOnDiagramNodeNullSelected() {
        this.presenter.onDiagramNodeSelected(null);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setValue((Object)new ProcessNodeSummary());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setNodeInstances(null);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setTimerInstances(null);
    }

    @Test
    public void testOnDiagramNodeSelected() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary timerNode = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "Timer", "_1");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start", "_0"), timerNode, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2"));
        NodeInstanceSummary timerNodeInstance = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("Timer").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(timerNodeInstance, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_2").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        TimerInstanceSummary timerInstance = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstances = Arrays.asList(timerInstance, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.singletonList(TimerSummary.builder().id(Long.valueOf(0L)).uniqueId("_1").build())).build());
        summary.setNodeInstances(nodeInstances);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(timerInstances);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onDiagramNodeSelected("_1");
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setValue((Object)timerNode);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setNodeInstances(Collections.singletonList(timerNodeInstance));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setTimerInstances(Collections.singletonList(timerInstance));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setNodeBadges((Map)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).onShow();
    }

    @Test
    public void testOnDiagramNodeSelectedByDoubleClick() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary timerNode = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "Timer", "_11");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start", "_0"), timerNode, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2"));
        NodeInstanceSummary timerNodeInstance = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_2").withType("Timer").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(timerNodeInstance, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_1").withType("SubProcessNode").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        TimerInstanceSummary timerInstance = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstances = Arrays.asList(timerInstance, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.singletonList(TimerSummary.builder().id(Long.valueOf(0L)).uniqueId("_1").build())).build());
        summary.setNodeInstances(nodeInstances);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(timerInstances);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onDiagramNodeSelectedByDoubleClick("_1");
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeInstances(Collections.singletonList(timerNodeInstance));
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((EventSourceMock)Mockito.verify(this.processInstanceEvent)).fire(Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setTimerInstances(Collections.singletonList(timerInstance));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).onShow();
        List<NodeInstanceSummary> nodeInstancesMultipleSubProcess = Arrays.asList(timerNodeInstance, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName("one").withNodeUniqueName("_1").withType("SubProcessNode").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(5L)).withName("two").withNodeUniqueName("_1").withType("SubProcessNode").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        summary.setNodeInstances(nodeInstancesMultipleSubProcess);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onDiagramNodeSelectedByDoubleClick("_1");
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeInstances(Collections.singletonList(timerNodeInstance));
        ((AlertPopupView)Mockito.verify((Object)this.alertPopup)).alert((String)Matchers.any(), (String)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setTimerInstances(Collections.singletonList(timerInstance));
    }

    @Test
    public void testOnNodeTriggered() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary humanTask = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "HumanTask", "_1");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start", "_0"), humanTask, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2"));
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.emptyList()).build());
        summary.setNodeInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(Collections.emptyList());
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onProcessNodeTrigger(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).triggerProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setValue((Object)new ProcessNodeSummary());
    }

    @Test
    public void testOnNodeInstanceCancelled() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        NodeInstanceSummary humanTask = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build();
        ProcessInstanceDiagramSummary summary = this.createHumanTaskProcessInstanceDiagramSummary(humanTask);
        new ProcessInstanceDiagramSummary();
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onNodeInstanceCancel(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).cancelProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testOnNodeInstanceReTriggered() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        NodeInstanceSummary humanTask = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build();
        ProcessInstanceDiagramSummary summary = this.createHumanTaskProcessInstanceDiagramSummary(humanTask);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), (String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onNodeInstanceReTrigger(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).reTriggerProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testOnTimerInstanceReschedule() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        TimerInstanceSummary timer = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstance = Arrays.asList(timer, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build());
        summary.setNodeInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(timerInstance);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onTimerInstanceReschedule(timer);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).rescheduleTimerInstance(processInstance.getProcessInstanceKey(), timer);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testTimerInstanceForNode() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        List<TimerSummary> timers = Arrays.asList(TimerSummary.builder().id(Long.valueOf(0L)).nodeId(Long.valueOf(1L)).uniqueId("_1").build(), TimerSummary.builder().id(Long.valueOf(1L)).nodeId(Long.valueOf(2L)).uniqueId("_2").build());
        TimerInstanceSummary t1 = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("t1").build();
        TimerInstanceSummary t2 = TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("t2").build();
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(timers).build());
        summary.setNodeInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(Arrays.asList(t1, t2));
        this.presenter.setProcessInstance(processInstance);
        Assertions.assertThat((List)this.presenter.getTimerInstanceForNode("_1")).containsExactly((Object[])new TimerInstanceSummary[]{t1});
        Assertions.assertThat((List)this.presenter.getTimerInstanceForNode("_2")).containsExactly((Object[])new TimerInstanceSummary[]{t2});
        Assertions.assertThat((List)this.presenter.getTimerInstanceForNode("_3")).isEmpty();
        Assertions.assertThat((List)this.presenter.getTimerInstanceForNode(null)).isEmpty();
    }

    @Test
    public void testIsProcessNodeTypeTriggerAllowed() {
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(null));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary()));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "StartNode", "_1")));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "Join", "_1")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "Split", "_1")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "HumanTaskNode", "_1")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "TimerNode", "_1")));
    }

    @Test
    public void testCustomColorFromPreferences() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessInstanceDiagramSummary summary = this.createHumanTaskProcessInstanceDiagramSummary(null);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey(), this.completeNodeColor, this.completeNodeBorderColor, this.activeNodeBorderColor);
    }

    private ProcessInstanceDiagramSummary createHumanTaskProcessInstanceDiagramSummary(NodeInstanceSummary humanTask) {
        if (humanTask == null) {
            humanTask = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build();
        }
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(humanTask, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_2").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(Collections.emptyList()).timers(Collections.emptyList()).build());
        summary.setNodeInstances(nodeInstances);
        return summary;
    }

    @Test
    public void testLoadProcessInstanceDetails() {
        ProcessInstanceDiagramSummary summary = this.createHumanTaskProcessInstanceDiagramSummary(null);
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setProcessNodes((List)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setShowOrHideNodeActionsCommand((com.google.gwt.user.client.Command)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setShowOrHideParentAndSubProcessPanelCommand((com.google.gwt.user.client.Command)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showOrHideParentAndSubProcessPanelTriggered();
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).expandDiagram();
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).disableExpandAnchor();
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showOrHideNodeActionsTriggered();
    }

    @Test
    public void testShowOrHideNodeActions() {
        ProcessInstanceSummary processInstanceActive = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withState(Integer.valueOf(1)).build();
        this.presenter.showOrHideNodeActions(false, processInstanceActive);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showNodeActions();
        ProcessInstanceSummary processInstanceCompleted = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withState(Integer.valueOf(2)).build();
        this.presenter.showOrHideNodeActions(false, processInstanceCompleted);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).hideNodeActions();
    }

    @Test
    public void testShowOrHideParentAndSubProcessPanel() {
        ProcessInstanceDiagramSummary summary = this.createHumanTaskProcessInstanceDiagramSummary(null);
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        summary.setParentProcessInstanceSummary(ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(10L)).withProcessName("parentProcess").build());
        List<ProcessInstanceSummary> list = Arrays.asList(ProcessInstanceSummary.builder().withParentId(Long.valueOf(10L)).withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessId("sub-process-one").withProcessInstanceId(Long.valueOf(11L)).withProcessName("sub-process-one").build(), ProcessInstanceSummary.builder().withParentId(Long.valueOf(10L)).withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessId("sub-process-two").withProcessInstanceId(Long.valueOf(12L)).withProcessName("sub-process-two").build());
        this.presenter.showOrHideParentAndSubProcessPanel(processInstance, list);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showParentAndSubProcessPanel();
        this.presenter.showOrHideParentAndSubProcessPanel(null, Collections.emptyList());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).hideParentAndSubProcessPanel();
    }

    @Test
    public void testLoadTimerInstancesWithException() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary timerNode = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "Timer", "_1");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start", "_0"), timerNode, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2"));
        NodeInstanceSummary timerNodeInstance = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("Timer").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(timerNodeInstance, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_2").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        TimerInstanceSummary timerInstance = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstances = Arrays.asList(timerInstance, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.singletonList(TimerSummary.builder().id(Long.valueOf(0L)).uniqueId("_1").build())).build());
        summary.setNodeInstances(nodeInstances);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)summary);
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenThrow(new Throwable[]{(Throwable)Mockito.mock(KieServicesHttpException.class)});
        this.presenter.setProcessInstance(processInstance);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setTimerInstances(timerInstances);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testLoadProcessInstanceDetailsWithException() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary timerNode = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "Timer", "_1");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start", "_0"), timerNode, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2"));
        NodeInstanceSummary timerNodeInstance = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withNodeUniqueName("_1").withType("Timer").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(timerNodeInstance, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withNodeUniqueName("_2").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withNodeUniqueName("_3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withNodeUniqueName("_4").withType("End").withCompleted(Boolean.valueOf(true)).build());
        TimerInstanceSummary timerInstance = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstances = Arrays.asList(timerInstance, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessDefinition(ProcessSummary.builder().nodes(nodes).timers(Collections.singletonList(TimerSummary.builder().id(Long.valueOf(0L)).uniqueId("_1").build())).build());
        summary.setNodeInstances(nodeInstances);
        summary.setSvgContent("svg String");
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenThrow(new Throwable[]{(Throwable)Mockito.mock(KieServicesHttpException.class)});
        Mockito.when((Object)this.processService.getProcessInstanceTimerInstances((ProcessInstanceKey)Matchers.eq((Object)processInstance.getProcessInstanceKey()))).thenReturn(timerInstances);
        this.presenter.setProcessInstance(processInstance);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setShowOrHideParentAndSubProcessPanelCommand((com.google.gwt.user.client.Command)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeBadges((Map)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showOrHideParentAndSubProcessPanelTriggered();
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSubProcessInstances((List)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setParentSelectedCommand((com.google.gwt.user.client.Command)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setProcessNodes((List)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setProcessNodes((List)Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setTimerInstances(timerInstances);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }
}

