/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details.multi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramUtil;
import org.jbpm.workbench.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.workbench.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.workbench.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="ProcessInstanceDetailsScreen", preferredWidth=500)
public class ProcessInstanceDetailsMultiPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    public ProcessInstanceDetailsMultiView view;
    @Inject
    ConfirmPopup confirmPopup;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PlaceManager placeManager;
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private ProcessInstanceDetailsPresenter detailsPresenter;
    @Inject
    private ProcessVariableListPresenter variableListPresenter;
    @Inject
    private ProcessDocumentListPresenter documentListPresenter;
    @Inject
    private RuntimeLogPresenter runtimeLogPresenter;
    private String selectedDeploymentId = "";
    private int selectedProcessInstanceStatus = 0;
    private String selectedProcessDefName = "";
    private PlaceRequest place;
    private String deploymentId = "";
    private String processId = "";
    private Long processInstanceId;
    private String serverTemplateId = "";
    private boolean forLog = false;

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    @WorkbenchPartView
    public UberView<ProcessInstanceDetailsMultiPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onProcessSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.deploymentId = event.getDeploymentId();
        this.processId = event.getProcessDefId();
        this.processInstanceId = event.getProcessInstanceId();
        this.serverTemplateId = event.getServerTemplateId();
        this.selectedDeploymentId = event.getDeploymentId();
        this.selectedProcessInstanceStatus = event.getProcessInstanceStatus();
        this.selectedProcessDefName = event.getProcessDefName();
        this.setIsForLog(event.isForLog());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.processInstanceId) + " - " + this.selectedProcessDefName));
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
        } else {
            this.view.displayAllTabs();
        }
        this.view.selectInstanceDetailsTab();
    }

    public void onRefresh() {
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(this.selectedDeploymentId, this.processInstanceId, this.processId, this.selectedProcessDefName, Integer.valueOf(this.selectedProcessInstanceStatus), this.isForLog(), this.serverTemplateId));
    }

    public void signalProcessInstance() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", String.valueOf(this.processInstanceId));
        placeRequestImpl.addParameter("deploymentId", this.deploymentId);
        placeRequestImpl.addParameter("serverTemplateId", this.serverTemplateId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void abortProcessInstance() {
        this.confirmPopup.show(this.constants.Abort_Confirmation(), this.constants.Abort(), this.constants.Abort_Process_Instance(), () -> ((ProcessService)this.processService.call(processInstance -> this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L))))).abortProcessInstance(this.serverTemplateId, this.deploymentId, this.processInstanceId));
    }

    public void goToProcessInstanceModelPopup() {
        if (this.place != null && !this.deploymentId.equals("")) {
            this.placeManager.goTo(ProcessDiagramUtil.buildPlaceRequest(this.serverTemplateId, this.deploymentId, this.processInstanceId));
        }
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return ProcessInstanceDetailsMultiPresenter.this.view.getOptionsButton();
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void variableListRefreshGrid() {
        this.variableListPresenter.refreshGrid();
    }

    public void documentListRefreshGrid() {
        this.documentListPresenter.refreshGrid();
    }

    public IsWidget getProcessIntanceView() {
        return this.detailsPresenter.getWidget();
    }

    public IsWidget getProcessVariablesView() {
        return this.variableListPresenter.getWidget();
    }

    public IsWidget getDocumentView() {
        return this.documentListPresenter.getWidget();
    }

    public IsWidget getLogsView() {
        return this.runtimeLogPresenter.getWidget();
    }

    public static interface ProcessInstanceDetailsMultiView
    extends UberView<ProcessInstanceDetailsMultiPresenter> {
        public IsWidget getOptionsButton();

        public void selectInstanceDetailsTab();

        public void displayAllTabs();

        public void displayOnlyLogTab();
    }
}

