/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.AbstractListView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractListView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class ProcessDefinitionListViewImpl
extends AbstractListView<ProcessSummary, ProcessDefinitionListPresenter>
implements ProcessDefinitionListPresenter.ProcessDefinitionListView {
    public static final String COL_ID_PROCESSNAME = "ProcessName";
    public static final String COL_ID_PROCESSVERSION = "ProcessVersion";
    public static final String COL_ID_PROJECT = "Project";
    public static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = Constants.INSTANCE;
    @Inject
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;

    protected ExtendedPagedTable<ProcessSummary> createListGrid(GridGlobalPreferences preferences) {
        return new ListTable(preferences);
    }

    public void init(final ProcessDefinitionListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_PROCESSNAME);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_PROCESSNAME);
        initColumns.add(COL_ID_PROCESSVERSION);
        initColumns.add(COL_ID_PROJECT);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("ProcessDefinitionsGrid", initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ProcessDefinitionListViewImpl.this.selectedItem = (GenericSummary)ProcessDefinitionListViewImpl.this.selectionModel.getLastSelectedObject();
                presenter.selectProcessDefinition((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem);
            }
        });
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessSummary> event) {
                DefaultSelectionEventManager.SelectAction ret = DefaultSelectionEventManager.SelectAction.DEFAULT;
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.isSelectionIgnoreColumn(event.getColumn())) {
                    ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return ret;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setEmptyTableCaption(this.constants.No_Process_Definitions_Found());
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column processNameColumn = this.initProcessNameColumn();
        Column versionColumn = this.initVersionColumn();
        Column projectColumn = this.initProjectColumn();
        ColumnMeta<ProcessSummary> actionsColumnMeta = this.initActionsColumn();
        ArrayList<Object> columnMetas = new ArrayList<Object>();
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(projectColumn, this.constants.Project()));
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 120.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(processNameColumn);
    }

    private Column initProcessNameColumn() {
        Column<ProcessSummary, String> processNameColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getProcessDefName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDefaultSortAscending(false);
        processNameColumn.setDataStoreName(COL_ID_PROCESSNAME);
        return processNameColumn;
    }

    private Column initVersionColumn() {
        Column<ProcessSummary, String> versionColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName(COL_ID_PROCESSVERSION);
        return versionColumn;
    }

    private Column initProjectColumn() {
        Column<ProcessSummary, String> projectColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getDeploymentId();
            }
        };
        projectColumn.setSortable(true);
        projectColumn.setDataStoreName(COL_ID_PROJECT);
        return projectColumn;
    }

    private ColumnMeta<ProcessSummary> initActionsColumn() {
        ConditionalKebabActionCell cell = (ConditionalKebabActionCell)this.conditionalKebabActionCell.get();
        cell.setActions(this.getConditionalActions());
        Column<ProcessSummary, ProcessSummary> actionsColumn = new Column<ProcessSummary, ProcessSummary>((Cell)cell){

            public ProcessSummary getValue(ProcessSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        actionsColumn.setCellStyleNames("kie-table-view-pf-actions text-center");
        TextHeader header = new TextHeader(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.Actions());
        header.setHeaderStyleNames("text-center");
        ColumnMeta actionsColMeta = new ColumnMeta((Column)actionsColumn, "");
        actionsColMeta.setHeader((Header)header);
        return actionsColMeta;
    }

    protected List<ConditionalAction<ProcessSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Start(), processSummary -> ((ProcessDefinitionListPresenter)this.presenter).openGenericForm(processSummary.getProcessDefId(), processSummary.getDeploymentId(), processSummary.getProcessDefName()), ((ProcessDefinitionListPresenter)this.presenter).getStartCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.View_Process_Instances(), processSummary -> ((ProcessDefinitionListPresenter)this.presenter).viewProcessInstances(processSummary.getProcessDefId()), ((ProcessDefinitionListPresenter)this.presenter).getViewProcessInstanceActionCondition(), Boolean.valueOf(true)));
    }
}

