/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.diagram;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.service.ProcessImageService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

@Dependent
public class ProcessDiagramPresenter {
    @Inject
    private ProcessDiagramWidgetView view;
    private Caller<ProcessImageService> processImageService;
    private Constants constants = Constants.INSTANCE;

    @Inject
    public void setProcessImageService(Caller<ProcessImageService> processImageService) {
        this.processImageService = processImageService;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        String containerId = event.getDeploymentId();
        Long processInstanceId = event.getProcessInstanceId();
        String serverTemplateId = event.getServerTemplateId();
        if (processInstanceId != null) {
            ((ProcessImageService)this.processImageService.call(svgContent -> this.displayImage((String)svgContent))).getProcessInstanceDiagram(serverTemplateId, containerId, processInstanceId);
        }
    }

    public void onProcessSelectionEvent(@Observes ProcessDefSelectionEvent event) {
        String containerId = event.getDeploymentId();
        String serverTemplateId = event.getServerTemplateId();
        String processId = event.getProcessId();
        ((ProcessImageService)this.processImageService.call(svgContent -> this.displayImage((String)svgContent))).getProcessDiagram(serverTemplateId, containerId, processId);
    }

    protected void displayImage(String svgContent) {
        if (svgContent == null || svgContent.isEmpty()) {
            this.view.displayMessage(this.constants.Process_Diagram_Not_Found());
        } else {
            this.view.displayImage(svgContent);
        }
    }

    @WorkbenchPartTitle
    public String getName() {
        return this.constants.Diagram();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    public static interface View
    extends HasBusyIndicator,
    IsWidget {
    }
}

