/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.forms.client.display.process.QuickNewProcessInstancePopup;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListFilterSettingsManager;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessInstanceListScreen")
public class ProcessInstanceListPresenter
extends AbstractMultiGridPresenter<ProcessInstanceSummary, ProcessInstanceListView> {
    protected final List<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
    private final Constants constants = Constants.INSTANCE;
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Instances());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Instances(), detailLabel, "ProcessInstanceDetailsScreen");
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, FilterSettings tableSettings, final boolean lastPage) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long processInstanceId = DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i);
                    String variableName = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"variableId", (int)i);
                    String variableValue = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"value", (int)i);
                    for (ProcessInstanceSummary pis : ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet) {
                        if (!pis.getProcessInstanceId().equals(processInstanceId)) continue;
                        pis.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).addDomainSpecifColumns((ExtendedPagedTable<ProcessInstanceSummary>)((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).getListGrid(), columns);
                ProcessInstanceListPresenter.this.updateDataOnCallback(ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
            }
        };
    }

    protected DataSetReadyCallback getDataSetReadyCallback(final Integer startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && ProcessInstanceListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    String filterValue;
                    ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.clear();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.add(ProcessInstanceListPresenter.this.createProcessInstanceSummaryFromDataSet(dataSet, i));
                    }
                    boolean lastPage = false;
                    if (dataSet.getRowCount() < ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).getListGrid().getPageSize()) {
                        lastPage = true;
                    }
                    if ((filterValue = ProcessInstanceListPresenter.this.isFilteredByProcessId(tableSettings.getDataSetLookup().getOperationList())) != null) {
                        ProcessInstanceListPresenter.this.getDomainSpecifDataForProcessInstances(startRange, filterValue, lastPage);
                    } else {
                        ProcessInstanceListPresenter.this.updateDataOnCallback(ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
                    }
                }
                ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).hideBusyIndicator();
            }

            public boolean onError(ClientRuntimeError error) {
                ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).hideBusyIndicator();
                ProcessInstanceListPresenter.this.showErrorPopup(ProcessInstanceListPresenter.this.constants.ResourceCouldNotBeLoaded(ProcessInstanceListPresenter.this.commonConstants.Process_Instances()));
                return false;
            }
        };
    }

    void showErrorPopup(String message) {
        ErrorPopup.showMessage((String)message);
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(int startRange, String filterValue, boolean lastPage) {
        FilterSettings variablesTableSettings = this.filterSettingsManager.getVariablesFilterSettings(filterValue);
        variablesTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("processInstanceId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, variablesTableSettings, lastPage));
    }

    protected ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"externalId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processName", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processVersion", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"status", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"start_date", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"end_date", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"user_identity", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processInstanceDescription", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"correlationKey", (int)i), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"parentProcessInstanceId", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"lastModificationDate", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"slaCompliance", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"sla_due_date", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"errorCount", (int)i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    public void abortProcessInstance(String containerId, long processInstanceId) {
        ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance(processInstanceId));
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        })).abortProcessInstance(this.getSelectedServerTemplate(), containerId, Long.valueOf(processInstanceId));
    }

    public void abortProcessInstances(List<String> containers, List<Long> processInstanceIds) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        })).abortProcessInstances(this.getSelectedServerTemplate(), containers, processInstanceIds);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        StringBuilder processIdsParam = new StringBuilder();
        StringBuilder deploymentIdsParam = new StringBuilder();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.Signaling_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            processIdsParam.append(selected.getId() + ",");
            deploymentIdsParam.append(selected.getDeploymentId() + ",");
        }
        if (processIdsParam.length() == 0) {
            return;
        }
        processIdsParam.deleteCharAt(processIdsParam.length() - 1);
        deploymentIdsParam.deleteCharAt(deploymentIdsParam.length() - 1);
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        placeRequestImpl.addParameter("deploymentId", deploymentIdsParam.toString());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            ids.add(selected.getProcessInstanceId());
            containers.add(selected.getDeploymentId());
            ((ProcessInstanceListView)this.view).displayNotification(this.constants.Aborting_Process_Instance(selected.getId()));
        }
        if (ids.size() > 0) {
            this.abortProcessInstances(containers, ids);
        }
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new PrimaryActionMenuBuilder(this.constants.New_Process_Instance(), () -> {
            String selectedServerTemplate = this.getSelectedServerTemplate();
            if (selectedServerTemplate != null && !selectedServerTemplate.isEmpty()) {
                this.newProcessInstancePopup.show(selectedServerTemplate);
            } else {
                ((ProcessInstanceListView)this.view).displayNotification(this.constants.SelectServerTemplate());
            }
        })).endMenu()).build();
    }

    public void signalProcessInstance(ProcessInstanceSummary processInstance) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
        placeRequestImpl.addParameter("deploymentId", processInstance.getDeploymentId());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void selectProcessInstance(ProcessInstanceSummary summary) {
        this.setupDetailBreadcrumb(this.constants.ProcessInstanceBreadcrumb(summary.getProcessInstanceId()));
        this.placeManager.goTo("ProcessInstanceDetailsScreen");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), summary.getState(), this.getSelectedServerTemplate()));
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            this.refreshGrid();
        }
    }

    @Inject
    public void setFilterSettingsManager(ProcessInstanceListFilterSettingsManager filterSettingsManager) {
        super.setFilterSettingsManager((FilterSettingsManager)filterSettingsManager);
    }

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    public void setupActiveSearchFilters() {
        Optional processInstanceSearch;
        boolean hasSearchParam = false;
        Optional processDefinitionSearch = this.getSearchParameter("processDefinitionId");
        if (processDefinitionSearch.isPresent()) {
            String processDefinitionId = (String)processDefinitionSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)processDefinitionId)), this.constants.Process_Definition_Id(), processDefinitionId, processDefinitionId, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)v))));
            hasSearchParam = true;
        }
        if ((processInstanceSearch = this.getSearchParameter("processInstanceId")).isPresent()) {
            String processInstanceId = (String)processInstanceSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)processInstanceId)), this.constants.Id(), processInstanceId, processInstanceId, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))));
            hasSearchParam = true;
        }
        if (!hasSearchParam) {
            this.setupDefaultActiveSearchFilters();
        }
    }

    public void setupDefaultActiveSearchFilters() {
        this.addActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)String.valueOf(1))), this.constants.State(), this.constants.Active(), String.valueOf(1), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
    }

    public void openJobsView(String pid) {
        this.navigateToPerspective("Requests", "processInstanceId", pid);
    }

    public void openTaskView(String pid) {
        this.navigateToPerspective(this.isUserAuthorizedForPerspective("TaskAdmin") ? "TaskAdmin" : "Tasks", "processInstanceId", pid);
    }

    public void openErrorView(String pid) {
        DefaultPlaceRequest request = new DefaultPlaceRequest("ExecutionErrors");
        request.addParameter("processInstanceId", pid);
        request.addParameter("isErrorAck", Boolean.toString(false));
        this.placeManager.goTo((PlaceRequest)request);
    }

    public Predicate<ProcessInstanceSummary> getSignalActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getAbortActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getViewJobsActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("Requests");
    }

    public Predicate<ProcessInstanceSummary> getViewTasksActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("TaskAdmin") || this.isUserAuthorizedForPerspective("Tasks");
    }

    public Predicate<ProcessInstanceSummary> getViewErrorsActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ExecutionErrors") && pis.getErrorCount() != null && pis.getErrorCount() > 0;
    }

    public static interface ProcessInstanceListView
    extends MultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter> {
        public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> var1, Set<String> var2);
    }
}

