/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.pr.client.editors.instance.log.WorkItemParameterListViewImpl;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.TaskStatusConverter;
import org.jbpm.workbench.pr.model.WorkItemParameterSummary;
import org.jbpm.workbench.pr.model.WorkItemSummary;

@Dependent
@Templated
public class ProcessInstanceLogItemDetailsView
implements IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="nodeDetailsContainer")
    Div nodeDetailsContainer;
    @Inject
    @DataField(value="humanTaskContainer")
    Div humanTaskContainer;
    @Inject
    @DataField(value="workItemDetailsContainer")
    Div workItemDetailsContainer;
    @Inject
    @DataField(value="createdOn")
    Span createdOn;
    @Inject
    @DataField(value="createdByLabel")
    Span createdByLabel;
    @Inject
    @DataField(value="createdBy")
    Span createdBy;
    @Inject
    @DataField(value="updatedOn")
    Span updatedOn;
    @Inject
    @DataField(value="taskId")
    Span taskId;
    @Inject
    @DataField(value="taskStatus")
    Span taskStatus;
    @Inject
    @DataField(value="actualOwner")
    Span actualOwner;
    @Inject
    @DataField(value="description")
    Span description;
    @Inject
    @DataField(value="workItemDetails")
    Div workItemDetails;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @Bound
    @ListContainer(value="dl")
    @DataField(value="params")
    private ListComponent<WorkItemParameterSummary, WorkItemParameterListViewImpl> workItemParameters;
    @Inject
    @AutoBound
    private DataBinder<List<WorkItemParameterSummary>> workItemParameterList;

    public HTMLElement getElement() {
        return this.nodeDetailsContainer;
    }

    public void setTaskDetailsData(TaskSummary model, Date logDate) {
        DOMUtil.removeCSSClass((HTMLElement)this.humanTaskContainer, (String)"hidden");
        this.taskId.setTextContent(((Long)model.getId()).toString());
        this.createdOn.setTextContent(DateUtils.getDateTimeStr((Date)model.getCreatedOn()));
        if (model.getCreatedBy() != null && !model.getCreatedBy().isEmpty()) {
            this.createdBy.setTextContent(model.getCreatedBy());
        } else {
            this.createdByLabel.setHidden(true);
            this.createdBy.setHidden(true);
        }
        this.updatedOn.setTextContent(DateUtils.getDateTimeStr((Date)logDate));
        this.taskStatus.setTextContent(new TaskStatusConverter().toWidgetValue(model.getTaskStatus()));
        if (model.getActualOwner() != null && !model.getActualOwner().isEmpty()) {
            this.actualOwner.setTextContent(model.getActualOwner());
        } else {
            this.actualOwner.setTextContent(this.constants.NotClaimed());
        }
        this.description.setTextContent(model.getDescription());
    }

    public void setDetailsData(WorkItemSummary model) {
        if (model != null && model.getParameters() != null && !model.getParameters().isEmpty()) {
            this.workItemParameterList.setModel((Object)model.getParameters());
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.workItemDetails, (String)"hidden");
        } else {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
            DOMUtil.addCSSClass((HTMLElement)this.workItemDetails, (String)"hidden");
        }
    }
}

