/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.TakesValue;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.logs.AbstractLogItemView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogItemDetailsView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;

@Dependent
@Templated
public class ProcessInstanceLogItemView
extends AbstractLogItemView<ProcessInstanceLogPresenter>
implements TakesValue<ProcessInstanceLogSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="detailsPanelDiv")
    private Div detailsPanelDiv;
    @Inject
    @DataField(value="detailsLink")
    private Anchor detailsLink;
    @Inject
    @DataField(value="detailsInfoDiv")
    private Div detailsInfoDiv;
    @Inject
    @AutoBound
    private DataBinder<ProcessInstanceLogSummary> logSummary;
    @Inject
    private ProcessInstanceLogItemDetailsView workItemView;

    public ProcessInstanceLogSummary getValue() {
        return (ProcessInstanceLogSummary)this.logSummary.getModel();
    }

    public void setValue(ProcessInstanceLogSummary model) {
        this.logSummary.setModel((Object)model);
        this.setLogTime(model.getDate());
        this.setLogIcon(model);
        this.setLogInfo(model);
        this.setLogType(model);
        this.setDetails(model);
    }

    private void setLogIcon(ProcessInstanceLogSummary model) {
        this.tooltip((HTMLElement)this.logIcon);
        String iconClass = "list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm";
        if (this.isHumanTask(model) || this.isStartNode(model) && !model.isCompleted()) {
            iconClass = iconClass + " fa fa-user";
            this.logIcon.setAttribute("data-original-title", this.constants.Human_Task());
        } else {
            iconClass = iconClass + " fa fa-cogs";
            this.logIcon.setAttribute("data-original-title", this.constants.System_Task());
        }
        if (model.isCompleted()) {
            iconClass = iconClass + " kie-timeline-icon--completed";
        }
        this.logIcon.setClassName(iconClass);
    }

    private void setLogInfo(ProcessInstanceLogSummary model) {
        String agent = this.getAgent(model);
        if (model.isCompleted()) {
            this.logInfo.setTextContent(this.constants.NodeWasLeft(agent));
        } else {
            this.logInfo.setTextContent(this.constants.NodeWasEntered(agent));
        }
    }

    private void setLogType(ProcessInstanceLogSummary model) {
        String logTitle = model.getNodeType();
        String name = model.getName();
        if (this.isHumanTask(model)) {
            logTitle = this.constants.Task_(model.getName());
        } else if (name != null && name.trim().length() > 0) {
            logTitle = model.getNodeType() + " '" + name + "' ";
        }
        this.logTypeDesc.setTextContent(logTitle);
    }

    private void setDetails(ProcessInstanceLogSummary model) {
        if (model.getWorkItemId() == null) {
            this.detailsPanelDiv.setHidden(true);
        } else {
            String panelId = Document.get().createUniqueId();
            this.detailsLink.setAttribute("href", "#" + panelId);
            this.detailsInfoDiv.setId(panelId);
            this.detailsPanelDiv.setHidden(false);
        }
    }

    private String getAgent(ProcessInstanceLogSummary model) {
        if (this.isHumanTask(model) || this.isStartNode(model) && !model.isCompleted()) {
            return this.constants.Human();
        }
        return this.constants.System();
    }

    @EventHandler(value={"detailsLink"})
    public void loadProcessInstanceLogsDetails(@ForEvent(value={"click"}) MouseEvent event) {
        if (!this.detailsInfoDiv.hasChildNodes() && ((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId() != null) {
            if (this.isHumanTask((ProcessInstanceLogSummary)this.logSummary.getModel())) {
                ((ProcessInstanceLogPresenter)this.presenter).loadTaskDetails(((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId(), ((ProcessInstanceLogSummary)this.logSummary.getModel()).getDate(), this.workItemView);
            } else {
                ((ProcessInstanceLogPresenter)this.presenter).loadWorkItemDetails(((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId(), this.workItemView);
            }
            this.detailsInfoDiv.appendChild((Node)this.workItemView.getElement());
        }
    }

    private boolean isHumanTask(ProcessInstanceLogSummary model) {
        return LogUtils.NODE_TYPE_HUMAN_TASK.equals(model.getNodeType());
    }

    private boolean isStartNode(ProcessInstanceLogSummary model) {
        return LogUtils.NODE_TYPE_START.equals(model.getNodeType());
    }
}

