/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.variables.history;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.RangeChangeEvent;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.DataGridUtils;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.ext.widgets.common.client.tables.PopoverTextCell;
import org.uberfire.mvp.Command;

@Dependent
public class VariableHistoryPopup
extends BaseModal {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final Constants instance = Constants.INSTANCE;
    @UiField
    public FormControlStatic variableNameTextBox;
    @UiField
    public DataGrid<ProcessVariableSummary> processVarListGrid;
    @UiField
    public Pagination pagination;
    public SimplePager pager;
    private ListDataProvider<ProcessVariableSummary> dataProvider = new ListDataProvider();
    private ColumnSortEvent.ListHandler<ProcessVariableSummary> sortHandler;

    public VariableHistoryPopup() {
        this.setTitle(Constants.INSTANCE.History());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Ok(), new Command(){

            public void execute() {
                VariableHistoryPopup.this.closePopup();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public VariableHistoryPopup(DataGrid<ProcessVariableSummary> processVarListGrid, Pagination pagination, FormControlStatic variableNameTextBox) {
        this.processVarListGrid = processVarListGrid;
        this.pagination = pagination;
        this.variableNameTextBox = variableNameTextBox;
        this.init();
    }

    public void init() {
        this.pager = new SimplePager(SimplePager.TextLocation.CENTER, false, true);
        this.pagination.rebuild(this.pager);
        this.processVarListGrid.setEmptyTableWidget((Widget)new HTMLPanel(this.instance.No_History_For_This_Variable()));
        this.sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        this.processVarListGrid.addColumnSortHandler(this.sortHandler);
        this.pager.setDisplay(this.processVarListGrid);
        this.pager.setPageSize(5);
        this.processVarListGrid.addRangeChangeHandler(new RangeChangeEvent.Handler(){

            public void onRangeChange(RangeChangeEvent event) {
                VariableHistoryPopup.this.pagination.rebuild(VariableHistoryPopup.this.pager);
            }
        });
        Column<ProcessVariableSummary, String> valueColumn = new Column<ProcessVariableSummary, String>((Cell)new PopoverTextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getNewValue() != null ? object.getNewValue() : "";
            }
        };
        this.processVarListGrid.addColumn((Column)valueColumn, this.instance.Value());
        valueColumn.setSortable(true);
        this.sortHandler.setComparator((Column)valueColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                String o1NewValue = o1.getNewValue() != null ? o1.getNewValue() : "";
                String o2NewValue = o2.getNewValue() != null ? o2.getNewValue() : "";
                return o1NewValue.compareTo(o2NewValue);
            }
        });
        Column<ProcessVariableSummary, String> oldValueColumn = new Column<ProcessVariableSummary, String>((Cell)new PopoverTextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getOldValue() != null ? object.getOldValue() : "";
            }
        };
        oldValueColumn.setSortable(true);
        this.processVarListGrid.addColumn((Column)oldValueColumn, this.instance.Previous_Value());
        this.sortHandler.setComparator((Column)oldValueColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                String o1OldValue = o1.getOldValue() != null ? o1.getOldValue() : "";
                String o2OldValue = o2.getOldValue() != null ? o2.getOldValue() : "";
                return o1OldValue.compareTo(o2OldValue);
            }
        });
        Column<ProcessVariableSummary, String> lastTimeChangedColumn = new Column<ProcessVariableSummary, String>((Cell)new TextCell()){

            public void render(Cell.Context context, ProcessVariableSummary variableSummary, SafeHtmlBuilder sb) {
                String title = DateUtils.getDateTimeStr((Date)new Date(variableSummary.getTimestamp()));
                sb.append(DataGridUtils.createDivStart(title));
                super.render(context, (Object)variableSummary, sb);
                sb.append(DataGridUtils.createDivEnd());
            }

            public String getValue(ProcessVariableSummary variable) {
                return DataGridUtils.trimToColumnWidth(VariableHistoryPopup.this.processVarListGrid, this, DateUtils.getDateTimeStr((Date)new Date(variable.getTimestamp())));
            }
        };
        lastTimeChangedColumn.setSortable(true);
        this.sortHandler.setComparator((Column)lastTimeChangedColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                return new Long(o1.getTimestamp()).compareTo(new Long(o2.getTimestamp()));
            }
        });
        this.processVarListGrid.addColumn((Column)lastTimeChangedColumn, this.instance.Last_Modification());
        this.dataProvider.addDataDisplay(this.processVarListGrid);
    }

    public void show(String variableId, final List<ProcessVariableSummary> processVariableSummaries) {
        this.variableNameTextBox.setText(variableId);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                VariableHistoryPopup.this.loadVariableHistory(processVariableSummaries);
                VariableHistoryPopup.this.refreshTable();
            }
        });
        super.show();
    }

    public void closePopup() {
        this.hide();
    }

    public void refreshTable() {
        this.processVarListGrid.getColumnSortList().clear();
        this.processVarListGrid.getColumnSortList().push(new ColumnSortList.ColumnSortInfo(this.processVarListGrid.getColumn(2), false));
        this.processVarListGrid.redraw();
    }

    public void loadVariableHistory(List<ProcessVariableSummary> processVariableSummaries) {
        this.dataProvider.getList().clear();
        this.dataProvider.getList().addAll(processVariableSummaries);
        this.dataProvider.flush();
        this.pagination.rebuild(this.pager);
    }

    public ColumnSortEvent.ListHandler<ProcessVariableSummary> getSortHandler() {
        return this.sortHandler;
    }

    static interface Binder
    extends UiBinder<Widget, VariableHistoryPopup> {
    }
}

