/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.email.Connection;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUploadWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(FTPUploadWorkItemHandler.class);
    private String user;
    private String password;
    private String server;
    private String filePath;
    private File file;
    private int port;
    private FTPClient client;
    private Connection connection;
    private boolean result = false;

    public void setConnection(String host, String port, String userName, String password) {
        this.connection = new Connection();
        this.connection.setHost(host);
        this.connection.setPort(port);
        this.connection.setUserName(userName);
        this.connection.setPassword(password);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.user = (String)workItem.getParameter("User");
        this.password = (String)workItem.getParameter("Password");
        this.filePath = (String)workItem.getParameter("FilePath");
        this.file = (File)workItem.getParameter("File");
        if (this.client == null) {
            this.client = new FTPClient();
        }
        try {
            if (this.connection != null) {
                this.client.connect(this.connection.getHost(), Integer.parseInt(this.connection.getPort()));
                int reply = this.client.getReplyCode();
                if (FTPReply.isPositiveCompletion((int)reply)) {
                    if (this.client.login(this.user, this.password)) {
                        FileInputStream input = this.filePath != null ? new FileInputStream(this.filePath) : new FileInputStream(this.file);
                        this.client.setFileType(2);
                        this.setResult(this.client.storeFile(this.filePath, (InputStream)input));
                        this.client.logout();
                        manager.completeWorkItem(workItem.getId(), null);
                    } else {
                        logger.warn("Could not logon to FTP server, status returned {}", (Object)this.client.getStatus());
                    }
                } else {
                    logger.warn("Could not connect to FTP server, status returned {}", (Object)this.client.getStatus());
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abortWorkItem(workItem, manager);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setFTPClient(FTPClient client) {
        this.client = client;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

