/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.rest.Person;
import org.jbpm.process.workitem.rest.RESTServiceException;
import org.jbpm.process.workitem.rest.RESTWorkItemHandler;
import org.jbpm.process.workitem.rest.SimpleRESTApplication;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@RunWith(value=Parameterized.class)
public class RestWorkItemHandlerTest {
    private final boolean httpClient43;
    private String contentParamName;
    private static final String serverURL = "http://localhost:9998/test";
    private static Server server;

    @Parameterized.Parameters(name="Http Client 4.3 api = {0}, Content Param = {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, "Content"}, {false, "Content"}, {true, "ContentData"}, {false, "ContentData"});
    }

    public RestWorkItemHandlerTest(boolean httpClient43, String contentParamName) {
        this.httpClient43 = httpClient43;
        this.contentParamName = contentParamName;
    }

    @BeforeClass
    public static void initialize() throws Exception {
        SimpleRESTApplication application = new SimpleRESTApplication();
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)delegate.createEndpoint((Application)application, JAXRSServerFactoryBean.class);
        bean.setProvider((Object)new JAXBElementProvider());
        bean.setAddress("http://localhost:9998" + bean.getAddress());
        server = bean.create();
        server.start();
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (server != null) {
            server.stop();
            server.destroy();
        }
    }

    @Before
    public void setClientApiVersion() {
        RESTWorkItemHandler.HTTP_CLIENT_API_43 = this.httpClient43;
    }

    @Test
    public void testGETOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((String)"results cannot be null", (Object)results);
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithJSONHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("AcceptHeader", (Object)"application/json");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)406L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)"endpoint http://localhost:9998/test could not be reached: ", (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithXMLHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("AcceptHeader", (Object)"application/xml");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)406L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)"endpoint http://localhost:9998/test could not be reached: ", (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithTextHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("AcceptHeader", (Object)"text/plain");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithCustomTimeout() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"30000");
        workItem.setParameter("ReadTimeout", (Object)"25000");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithInvalidTimeout() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"");
        workItem.setParameter("ReadTimeout", (Object)"");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithQueryParam() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test?param=test");
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST test", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Post john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWthJSONHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Post john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("AcceptHeader", (Object)"application/json");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)406L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)"endpoint http://localhost:9998/test/xml could not be reached: ", (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWithXMLHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Post john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("AcceptHeader", (Object)"application/xml");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWithPathParamAndNoContent() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/john");
        workItem.setParameter("Method", (Object)"POST");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Created resource with name john", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithXMLHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("AcceptHeader", (Object)"application/xml");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithJSONHeader() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("AcceptHeader", (Object)"application/json");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)406L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)"endpoint http://localhost:9998/test/xml could not be reached: ", (Object)responseMsg);
    }

    @Test
    public void testPATCHOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PATCH");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNull((String)"result should be  null", (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)204L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed No Content"), (Object)responseMsg);
    }

    @Test
    public void testDELETEOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>-1</age><name>deleted john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml/john");
        workItem.setParameter("Method", (Object)"DELETE");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml/john");
        workItem.setParameter("Method", (Object)"HEAD");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
    }

    @Test
    public void testHandleErrorOnNotSuccessfulResponse() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/notexisting");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("HandleResponseErrors", (Object)"true");
        TestWorkItemManager manager = new TestWorkItemManager();
        try {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should throw exception as it was instructed to do so");
        }
        catch (WorkItemHandlerRuntimeException ex) {
            RESTServiceException e = (RESTServiceException)ex.getCause().getCause();
            Assert.assertEquals((long)405L, (long)e.getStatus());
            Assert.assertEquals((Object)"http://localhost:9998/test/notexisting", (Object)e.getEndoint());
            Assert.assertEquals((Object)"", (Object)e.getResponse());
        }
    }

    @Test
    public void testGETOperationWithXmlTrasformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Person Xml", (Object)result.getName());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithJsonTrasformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/json");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Person Json", (Object)result.getName());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWithXmlTransformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"Application/XML");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Post john", (Object)result.getName());
        Assert.assertEquals((long)25L, (long)result.getAge().intValue());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithXmlTransformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"Application/Xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)"<person><name>john</name><age>25</age></person>");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Put john", (Object)result.getName());
        Assert.assertEquals((long)25L, (long)result.getAge().intValue());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWithCompleteXmlTransformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        Person request = new Person();
        request.setAge(25);
        request.setName("john");
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)request);
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Post john", (Object)result.getName());
        Assert.assertEquals((long)25L, (long)result.getAge().intValue());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithXmlCharsetTrasformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml-charset");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Person Xml", (Object)result.getName());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithJsonCharsetTrasformation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/json-charset");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ResultClass", (Object)Person.class.getName());
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Person result = (Person)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Person Json", (Object)result.getName());
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithDefaultCharset() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String nonAsciiData = "\u0418\u0432\u0430\u043d";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put ????</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml-charset");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter(this.contentParamName, (Object)("<person><name>" + nonAsciiData + "</name><age>25</age></person>"));
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithSetCharset() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String nonAsciiData = "\u0418\u0432\u0430\u043d";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put \u0418\u0432\u0430\u043d</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml-charset");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("ContentTypeCharset", (Object)"UTF-8");
        workItem.setParameter(this.contentParamName, (Object)("<person><name>" + nonAsciiData + "</name><age>25</age></person>"));
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperationWithCharsetUnspecifiedViaParameter() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String nonAsciiData = "\u0418\u0432\u0430\u043d";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put " + nonAsciiData + "</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml-charset");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml; charset=utf-8");
        workItem.setParameter(this.contentParamName, (Object)("<person><name>" + nonAsciiData + "</name><age>25</age></person>"));
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testHeadersNull() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String headerKey = "headerKey";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)(headerKey + "="));
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertTrue((boolean)result.trim().isEmpty());
    }

    @Test
    public void testHeadersSingleValue() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String headerKey = "headerKey";
        String headerValue = "headerValue";
        String headers = headerKey + "=" + headerValue;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)headers);
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)headerValue, (Object)result);
    }

    @Test
    public void testHeadersValueWithEquals() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String headerKey = "Authorization";
        String headerValue = "Basic bcdabcdabcdabcdabcdabcdabcd==";
        String headers = headerKey + "=" + headerValue;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)headers);
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)headerValue, (Object)result);
    }

    @Test
    public void testHeadersMultipleValues() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String headerKey = "headerKey";
        String headerValues = "headerValue,headerValue2,headerValue3";
        String headers = headerKey + "=" + headerValues;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)headers);
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)headerValues, (Object)result);
    }

    @Test
    public void testHeadersMultipleHeaders() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        String headerKey1 = "headerKey";
        String headerValues1 = "headerValue,headerValue2,headerValue3";
        String headerKey2 = "headerKey2";
        String headerValues2 = "headerValue2,headerValue22,headerValue23";
        String headers = headerKey1 + "=" + headerValues1 + ";" + headerKey2 + "=" + headerValues2;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey1));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)headers);
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        String result = (String)results.get("Result");
        Assert.assertEquals((Object)headerValues1, (Object)result);
        workItem.setParameter("Url", (Object)("http://localhost:9998/test/header/" + headerKey2));
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Headers", (Object)headers);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        results = manager.getResults(Long.valueOf(workItem.getId()));
        result = (String)results.get("Result");
        Assert.assertEquals((Object)headerValues2, (Object)result);
    }

    @Test
    public void testGETCharsetOperation() throws UnsupportedEncodingException {
        String charset = "Windows-1252";
        String expected = "\u0160";
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/charset");
        workItem.setParameter("AcceptCharset", (Object)"Windows-1252");
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((String)"results cannot be null", (Object)results);
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)results.get("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)results.get("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGetContentTypeAndCharset() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ContentType", "application/xml");
        params.put("ContentTypeCharset", "UTF-8");
        Assert.assertEquals((Object)"application/xml;charset=UTF-8", (Object)handler.getContentTypeAndCharset(params));
        params.put("ContentType", "application/xml;charset=UTF-8");
        params.put("ContentTypeCharset", "SOME_WROMG_CHARSET");
        Assert.assertEquals((Object)"application/xml;charset=UTF-8", (Object)handler.getContentTypeAndCharset(params));
        params.remove("ContentTypeCharset");
        Assert.assertEquals((Object)"application/xml;charset=UTF-8", (Object)handler.getContentTypeAndCharset(params));
        params.remove("ContentType");
        Assert.assertNull((Object)handler.getContentTypeAndCharset(params));
    }

    @Test
    public void testHandleErrorOnNotSuccessfulResponseHandlingException() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler("test", "COMPLETE", "user", "password");
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/notexisting");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("HandleResponseErrors", (Object)"true");
        TestWorkItemManager manager = new TestWorkItemManager();
        try {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should throw exception as it was instructed to do so");
        }
        catch (ProcessWorkItemHandlerException ex) {
            RESTServiceException e = (RESTServiceException)ex.getCause().getCause();
            Assert.assertEquals((long)405L, (long)e.getStatus());
            Assert.assertEquals((Object)"http://localhost:9998/test/notexisting", (Object)e.getEndoint());
            Assert.assertEquals((Object)"", (Object)e.getResponse());
            Assert.assertEquals((Object)"test", (Object)ex.getProcessId());
            Assert.assertEquals((Object)"COMPLETE", (Object)ex.getStrategy().name());
        }
    }
}

