/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.rest.RESTWorkItemHandler;
import org.jbpm.process.workitem.rest.SimpleRESTApplication;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RestWorkitemHandlerClientCreationTest {
    private final boolean httpClient43 = true;
    private static final String serverURL = "http://localhost:9998/test";
    private static Server server;

    @BeforeClass
    public static void initialize() throws Exception {
        SimpleRESTApplication application = new SimpleRESTApplication();
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)delegate.createEndpoint((Application)application, JAXRSServerFactoryBean.class);
        bean.setProvider((Object)new JAXBElementProvider());
        bean.setAddress("http://localhost:9998" + bean.getAddress());
        server = bean.create();
        server.start();
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (server != null) {
            server.stop();
            server.destroy();
        }
    }

    @Before
    public void setClientApiVersion() {
        RESTWorkItemHandler.HTTP_CLIENT_API_43 = true;
    }

    @Test
    public void testPooledClientCreationWithDefaultTimeouts() {
        RESTWorkItemHandler handler = (RESTWorkItemHandler)Mockito.spy(RESTWorkItemHandler.class);
        Mockito.when((Object)handler.getDoCacheClient()).thenReturn((Object)true);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("Cookie", (Object)"name=value");
        workItem.setParameter("CookiePath", (Object)"/");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)2))).getHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).getNewPooledHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()));
        Assert.assertNotNull((Object)RESTWorkItemHandler.cachedClient);
        Assert.assertTrue((boolean)(RESTWorkItemHandler.cachedClient instanceof CloseableHttpClient));
        Assert.assertNotNull((Object)RESTWorkItemHandler.cachedClient.getConnectionManager());
    }

    @Test
    public void testPooledClientCreationWithSetTimeouts() {
        RESTWorkItemHandler handler = (RESTWorkItemHandler)Mockito.spy(RESTWorkItemHandler.class);
        Mockito.when((Object)handler.getDoCacheClient()).thenReturn((Object)true);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"4000");
        workItem.setParameter("ReadTimeout", (Object)"3000");
        workItem.setParameter("Cookie", (Object)"name=value");
        workItem.setParameter("CookiePath", (Object)"/");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)2))).getHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)0))).getNewPooledHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()));
        Assert.assertNotNull((Object)RESTWorkItemHandler.cachedClient);
        Assert.assertTrue((boolean)(RESTWorkItemHandler.cachedClient instanceof CloseableHttpClient));
        Assert.assertNotNull((Object)RESTWorkItemHandler.cachedClient.getConnectionManager());
    }

    @Test
    public void testSingleClientCreationOnMultipleCalls() {
        RESTWorkItemHandler handler = (RESTWorkItemHandler)Mockito.spy(RESTWorkItemHandler.class);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)serverURL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"4000");
        workItem.setParameter("ReadTimeout", (Object)"3000");
        workItem.setParameter("Cookie", (Object)"name=value");
        workItem.setParameter("CookiePath", (Object)"/");
        TestWorkItemManager manager = new TestWorkItemManager();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        workItem.setParameter("ConnectTimeout", (Object)"5000");
        workItem.setParameter("ReadTimeout", (Object)"4000");
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)2))).getHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        ((RESTWorkItemHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)0))).getNewPooledHttpClient(Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()));
    }
}

