/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.email.Email;
import org.jbpm.process.workitem.email.EmailWorkItemHandler;
import org.jbpm.process.workitem.email.SendHtml;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.MultipleAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.PlainAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class SendHtmlTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(SendHtmlTest.class);
    private Wiser wiser;
    private String emailHost;
    private String emailPort;
    private static String authUsername = "cpark";
    private static String authPassword = "yourbehindwhat?";
    private Random random = new Random();
    private int uniqueTestNum = -1;

    @Before
    public void setUp() throws Exception {
        int emailPortInt;
        this.uniqueTestNum = this.random.nextInt(Integer.MAX_VALUE);
        this.emailHost = "localhost";
        while ((emailPortInt = this.random.nextInt(65533)) < 4096) {
        }
        this.emailPort = Integer.toString(emailPortInt);
        this.wiser = new Wiser(Integer.parseInt(this.emailPort));
        this.wiser.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.wiser != null) {
            this.wiser.getMessages().clear();
            this.wiser.stop();
            this.wiser = null;
        }
    }

    @Test
    public void testConnectionEquals() {
        Connection connA = new Connection();
        Connection connB = new Connection();
        Assert.assertTrue((!connA.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((!connA.equals((Object)"og") ? 1 : 0) != 0);
        ExtendedConnection connExt = new ExtendedConnection();
        Assert.assertTrue((!connA.equals((Object)connExt) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)connA.equals((Object)connB));
        connA.setHost("Human");
        connA.setPort("Skin");
        connA.setUserName("Viral");
        connA.setPassword("Protein Gate");
        Assert.assertTrue((!connA.equals((Object)connB) ? 1 : 0) != 0);
        connB.setHost(connA.getHost());
        connB.setPort(new String(connA.getPort()));
        connB.setUserName(connA.getUserName());
        connB.setPassword(connA.getPassword());
        Assert.assertTrue((boolean)connA.equals((Object)connB));
        connA.setPassword(null);
        connB.setPassword(null);
        Assert.assertTrue((boolean)connA.equals((Object)connB));
        connA.setStartTls(true);
        Assert.assertTrue((!connA.equals((Object)connB) ? 1 : 0) != 0);
        connB.setStartTls(true);
        Assert.assertTrue((boolean)connA.equals((Object)connB));
        connB.setStartTls(false);
        Assert.assertTrue((!connA.equals((Object)connB) ? 1 : 0) != 0);
    }

    @Test
    public void verifyWiserServerWorks() throws Exception {
        String testMethodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        String toAddress = "boyd@crowdergang.org";
        String fromAddress = "rgivens@kty.us.gov";
        WorkItemImpl workItem = this.createEmailWorkItem(toAddress, fromAddress, testMethodName);
        Connection connection = new Connection(this.emailHost, this.emailPort);
        this.sendAndCheckThatMessagesAreSent(workItem, connection);
    }

    @Test
    public void sendHtmlWithAuthentication() throws Exception {
        this.wiser.getServer().setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TestAuthHandlerFactory());
        String testMethodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        String toAddress = "rgivens@kty.us.gov";
        String fromAddress = "whawkins@kty.us.gov";
        WorkItemImpl workItem = this.createEmailWorkItem(toAddress, fromAddress, testMethodName);
        Connection connection = new Connection(this.emailHost, this.emailPort, authUsername, authPassword);
        this.sendAndCheckThatMessagesAreSent(workItem, connection);
    }

    @Test
    public void sendHtmlWithAuthenticationAndAttachments() throws Exception {
        this.wiser.getServer().setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TestAuthHandlerFactory());
        String testMethodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        String toAddress = "rgivens@kty.us.gov";
        String fromAddress = "whawkins@kty.us.gov";
        WorkItemImpl workItem = this.createEmailWorkItemWithAttachment(toAddress, fromAddress, testMethodName);
        Connection connection = new Connection(this.emailHost, this.emailPort, authUsername, authPassword);
        Email email = EmailWorkItemHandler.createEmail((WorkItem)workItem, (Connection)connection);
        SendHtml.sendHtml((Email)email, (Connection)connection);
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        MimeMessage message = ((WiserMessage)messages.get(0)).getMimeMessage();
        Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)message.getSubject());
        Assert.assertTrue((boolean)Arrays.equals(InternetAddress.parse((String)((String)workItem.getParameter("To"))), message.getRecipients(Message.RecipientType.TO)));
        Assert.assertTrue((boolean)(message.getContent() instanceof Multipart));
        Multipart multipart = (Multipart)message.getContent();
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (!"attachment".equalsIgnoreCase(bodyPart.getDisposition())) continue;
            Assert.assertEquals((Object)"email.gif", (Object)bodyPart.getFileName());
        }
    }

    @Test
    public void sendHtmlWithBadAuthentication() throws Exception {
        this.wiser.getServer().setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TestAuthHandlerFactory());
        String testMethodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        String toAddress = "mags@bennetstore.com";
        String fromAddress = "rgivens@kty.us.gov";
        this.checkBadAuthentication(toAddress, fromAddress, testMethodName, authUsername, "bad password");
        this.checkBadAuthentication(toAddress, fromAddress, testMethodName, "badUserName", authPassword);
    }

    @Test
    public void useEmailWorkItemHandlerWithAuthentication() throws Exception {
        this.wiser.getServer().setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TestAuthHandlerFactory());
        String testMethodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        String toAddress = "rgivens@yahoo.com";
        String fromAddress = "rgivens@kty.us.gov";
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, authUsername, authPassword);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)toAddress);
        workItem.setParameter("From", (Object)fromAddress);
        workItem.setParameter("Reply-To", (Object)fromAddress);
        workItem.setParameter("Subject", (Object)("Test mail for " + testMethodName));
        workItem.setParameter("Body", (Object)"Don't forget to check on Boyd later today.");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        for (WiserMessage wiserMessage : messages) {
            MimeMessage message = wiserMessage.getMimeMessage();
            Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)message.getSubject());
            Assert.assertTrue((boolean)Arrays.equals(InternetAddress.parse((String)toAddress), message.getRecipients(Message.RecipientType.TO)));
        }
    }

    private void sendAndCheckThatMessagesAreSent(WorkItemImpl workItem, Connection connection) throws Exception {
        Email email = EmailWorkItemHandler.createEmail((WorkItem)workItem, (Connection)connection);
        SendHtml.sendHtml((Email)email, (Connection)connection);
        List messages = this.wiser.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        for (WiserMessage wiserMessage : messages) {
            MimeMessage message = wiserMessage.getMimeMessage();
            Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)message.getSubject());
            Assert.assertTrue((boolean)Arrays.equals(InternetAddress.parse((String)((String)workItem.getParameter("To"))), message.getRecipients(Message.RecipientType.TO)));
        }
    }

    private void checkBadAuthentication(String toAddress, String fromAddress, String testMethodName, String username, String password) {
        WorkItemImpl workItem = this.createEmailWorkItem(toAddress, fromAddress, testMethodName);
        Connection connection = new Connection(this.emailHost, this.emailPort, username, password);
        Email email = EmailWorkItemHandler.createEmail((WorkItem)workItem, (Connection)connection);
        try {
            SendHtml.sendHtml((Email)email, (Connection)connection);
        }
        catch (Throwable t) {
            Assert.assertTrue((String)("Unexpected exception of type " + t.getClass().getSimpleName() + ", not " + t.getClass().getSimpleName()), (boolean)(t instanceof RuntimeException));
            Assert.assertNotNull((String)"Expected RuntimeException to have a cause.", (Object)t.getCause());
            Throwable cause = t.getCause();
            Assert.assertNotNull((String)"Expected cause to have a cause.", (Object)cause.getCause());
            cause = cause.getCause();
            Assert.assertTrue((String)("Unexpected exception of type " + cause.getClass().getSimpleName() + ", not " + cause.getClass().getSimpleName()), (boolean)(cause instanceof AuthenticationFailedException));
        }
    }

    private WorkItemImpl createEmailWorkItem(String toAddress, String fromAddress, String testMethodName) {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)toAddress);
        workItem.setParameter("From", (Object)fromAddress);
        workItem.setParameter("Reply-To", (Object)fromAddress);
        String subject = this.getClass().getSimpleName() + " test message [" + this.uniqueTestNum + "]";
        String body = "\nThis is the test message generated by the " + testMethodName + " test (" + this.uniqueTestNum + ").\n";
        workItem.setParameter("Subject", (Object)subject);
        workItem.setParameter("Body", (Object)body);
        return workItem;
    }

    private WorkItemImpl createEmailWorkItemWithAttachment(String toAddress, String fromAddress, String testMethodName) {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)toAddress);
        workItem.setParameter("From", (Object)fromAddress);
        workItem.setParameter("Reply-To", (Object)fromAddress);
        String subject = this.getClass().getSimpleName() + " test message [" + this.uniqueTestNum + "]";
        String body = "\nThis is the test message generated by the " + testMethodName + " test (" + this.uniqueTestNum + ").\n";
        workItem.setParameter("Subject", (Object)subject);
        workItem.setParameter("Body", (Object)body);
        workItem.setParameter("Attachments", (Object)"classpath:/icons/email.gif");
        return workItem;
    }

    private static class TestAuthHandlerFactory
    implements AuthenticationHandlerFactory {
        MultipleAuthenticationHandlerFactory authHandleFactory = new MultipleAuthenticationHandlerFactory();

        public TestAuthHandlerFactory() {
            UsernamePasswordValidator validator = new UsernamePasswordValidator(){

                public void login(String username, String password) throws LoginFailedException {
                    if (!authUsername.equals(username) || !authPassword.equals(password)) {
                        logger.debug("Tried to login with user/password [{}/{}]", (Object)username, (Object)password);
                        throw new LoginFailedException("Incorrect password for user " + authUsername);
                    }
                }
            };
            this.authHandleFactory.addFactory((AuthenticationHandlerFactory)new LoginAuthenticationHandlerFactory(validator));
            this.authHandleFactory.addFactory((AuthenticationHandlerFactory)new PlainAuthenticationHandlerFactory(validator));
        }

        public AuthenticationHandler create() {
            return this.authHandleFactory.create();
        }

        public List<String> getAuthenticationMechanisms() {
            return this.authHandleFactory.getAuthenticationMechanisms();
        }
    }

    private class ExtendedConnection
    extends Connection {
        private String extraField;

        private ExtendedConnection() {
        }
    }
}

