/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jpa;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.transaction.UserTransaction;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.process.workitem.jpa.JPAWorkItemHandler;
import org.jbpm.process.workitem.jpa.Product;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class JPAWorkItemHandlerTest {
    private static final String P_UNIT = "org.jbpm.test.jpaWIH";
    private static EntityManagerFactory emf;
    private static WorkItemHandler handler;
    private static TestH2Server h2Server;
    private static UserTransaction ut;

    @BeforeClass
    public static void configure() throws InterruptedException, NamingException {
        JPAWorkItemHandlerTest.setupPoolingDataSource();
        ClassLoader classLoader = JPAWorkItemHandler.class.getClassLoader();
        handler = new JPAWorkItemHandler(P_UNIT, classLoader);
        emf = Persistence.createEntityManagerFactory((String)P_UNIT);
        ut = JPAWorkItemHandlerTest.getUserTransaction();
    }

    @Test
    public void createOnProcessTest() throws Exception {
        String DESC = "Table";
        Product p = new Product(DESC, 10.0f);
        this.startJPAWIHProcess("CREATE", p);
        UserTransaction ut = JPAWorkItemHandlerTest.getUserTransaction();
        ut.begin();
        EntityManager em = emf.createEntityManager();
        TypedQuery products = em.createQuery("select p from Product p where p.description = :desc", Product.class);
        products.setParameter("desc", (Object)DESC);
        List resultList = products.getResultList();
        Product result = (Product)resultList.iterator().next();
        Assert.assertEquals((Object)DESC, (Object)result.getDescription());
        em.remove((Object)result);
        em.flush();
        em.close();
        ut.commit();
    }

    @Test
    public void removeOnProcessTest() throws Exception {
        Product p = new Product("A Product", 10.0f);
        ut.begin();
        EntityManager em = emf.createEntityManager();
        em.persist((Object)p);
        long id = p.getId();
        em.close();
        ut.commit();
        this.startJPAWIHProcess("DELETE", p);
        ut.begin();
        em = emf.createEntityManager();
        p = (Product)em.find(Product.class, (Object)id);
        Assert.assertNull((Object)p);
        ut.commit();
    }

    @Test
    public void updateOnProcessTest() throws Exception {
        String DESC = "Table";
        String NEW_DESC = "Red Table";
        Product p = new Product(DESC, 10.0f);
        ut.begin();
        EntityManager em = emf.createEntityManager();
        em.persist((Object)p);
        long id = p.getId();
        em.close();
        ut.commit();
        p.setDescription(NEW_DESC);
        this.startJPAWIHProcess("UPDATE", p);
        ut.begin();
        em = emf.createEntityManager();
        p = (Product)em.find(Product.class, (Object)id);
        Assert.assertEquals((Object)p.getDescription(), (Object)NEW_DESC);
        ut.commit();
        this.removeProduct(p);
    }

    @Test
    public void getActionTest() throws Exception {
        Product newProd = this.create(new Product("some product", 0.1f));
        String id = String.valueOf(newProd.getId());
        Product product = this.getProduct(id);
        Assert.assertEquals((Object)product.getDescription(), (Object)newProd.getDescription());
        this.removeProduct(product);
    }

    @Test
    public void queryActionTest() throws Exception {
        Product p1 = this.create(new Product("some prod", 2.0f));
        Product p2 = this.create(new Product("other prod", 3.0f));
        List<Product> products = this.getAllProducts();
        Assert.assertEquals((long)2L, (long)products.size());
        this.removeProduct(p1);
        this.removeProduct(p2);
    }

    @Test
    public void queryWithParameterActionTest() throws Exception {
        String DESC = "Cheese";
        Product p1 = new Product("Bread", 2.0f);
        Product p2 = new Product("Milk", 3.0f);
        Product p3 = new Product(DESC, 5.0f);
        this.create(p1);
        this.create(p2);
        this.create(p3);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Action", (Object)"QUERY");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("desc", DESC);
        workItem.setParameter("Query", (Object)"SELECT p FROM Product p where p.description = :desc");
        workItem.setParameter("QueryParameters", params);
        UserTransaction ut = JPAWorkItemHandlerTest.getUserTransaction();
        ut.begin();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        ut.commit();
        List<Product> products = (List<Product>)workItem.getResult("QueryResults");
        Assert.assertEquals((long)1L, (long)products.size());
        products = this.getAllProducts();
        Assert.assertEquals((long)3L, (long)products.size());
        for (Product product : products) {
            this.removeProduct(product);
        }
        products = this.getAllProducts();
        Assert.assertEquals((long)0L, (long)products.size());
    }

    private void removeProduct(Product prod) throws Exception {
        ut.begin();
        EntityManager em = emf.createEntityManager();
        prod = (Product)em.find(Product.class, (Object)prod.getId());
        em.remove((Object)prod);
        em.close();
        ut.commit();
    }

    private Product create(Product newProd) throws Exception {
        ut.begin();
        EntityManager em = emf.createEntityManager();
        em.persist((Object)newProd);
        em.close();
        ut.commit();
        return newProd;
    }

    private List<Product> getAllProducts() throws Exception {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Action", (Object)"QUERY");
        workItem.setParameter("Query", (Object)"SELECT p FROM Product p");
        UserTransaction ut = JPAWorkItemHandlerTest.getUserTransaction();
        ut.begin();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        ut.commit();
        List products = (List)workItem.getResult("QueryResults");
        return products;
    }

    private Product getProduct(String id) throws Exception {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Action", (Object)"GET");
        workItem.setParameter("Type", (Object)"org.jbpm.process.workitem.jpa.Product");
        workItem.setParameter("Id", (Object)id);
        UserTransaction ut = JPAWorkItemHandlerTest.getUserTransaction();
        ut.begin();
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        ut.commit();
        Product product = (Product)workItem.getResult("Result");
        return product;
    }

    private void startJPAWIHProcess(String action, Product prod) throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironment env = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).addEnvironmentEntry("org.kie.internal.runtime.manager.TaskServiceFactory", (Object)new TaskServiceFactory(){

            public TaskService newTaskService() {
                return null;
            }

            public void close() {
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"JPAWIH.bpmn2"), ResourceType.BPMN2).get();
        RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(env);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        KieSession kSession = engine.getKieSession();
        JPAWorkItemHandler jpaWih = new JPAWorkItemHandler(P_UNIT, this.getClass().getClassLoader());
        kSession.getWorkItemManager().registerWorkItemHandler("JPAWIH", (WorkItemHandler)jpaWih);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", action);
        params.put("obj", prod);
        params.put("id", prod.getId());
        kSession.startProcess("org.jbpm.JPA_WIH", params);
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    private static UserTransaction getUserTransaction() throws NamingException {
        return (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
    }

    public static PoolingDataSource setupPoolingDataSource() {
        h2Server = new TestH2Server();
        h2Server.start();
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jpaWIH");
        pds.setClassName("org.h2.jdbcx.JdbcDataSource");
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("url", "jdbc:h2:mem:jpa-wih;MVCC=true");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }

    private static class TestH2Server {
        private Server realH2Server;

        private TestH2Server() {
        }

        public void start() {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    this.realH2Server = Server.createTcpServer((String[])new String[0]);
                    this.realH2Server.start();
                    System.out.println("Started H2 Server...");
                }
                catch (SQLException e) {
                    throw new RuntimeException("can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                System.out.println("Stopping H2 Server...");
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"target/jpa-wih", (boolean)true);
            super.finalize();
        }
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private WorkItem workItem;

        TestWorkItemManager(WorkItem workItem) {
            this.workItem = workItem;
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            ((WorkItemImpl)this.workItem).setResults(results);
        }

        public void abortWorkItem(long id) {
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

