/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.jbpm.process.workitem.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(FileTransformer.class);

    @Transformer
    public static String fileToString(File file) {
        try {
            String fileString = "";
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = reader.readLine()) != null) {
                fileString = fileString + line;
            }
            return fileString;
        }
        catch (Exception e) {
            logger.error("Failed to read file {}", (Object)file.getName());
            return null;
        }
    }

    @Transformer
    public static BufferedReader fileToBufferedReader(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            return reader;
        }
        catch (Exception e) {
            logger.error("Failed to read file {}", (Object)file.getName());
            return null;
        }
    }
}

