/*
 * Decompiled with CFR 0.152.
 */
package org.jpastebin.pastebin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpastebin.exceptions.PasteException;
import org.jpastebin.pastebin.PasteExpireDate;
import org.jpastebin.pastebin.PastebinLink;
import org.jpastebin.pastebin.PastebinPaste;
import org.jpastebin.pastebin.exceptions.ParseException;
import org.jpastebin.utils.web.Post;
import org.jpastebin.utils.web.Web;
import org.jpastebin.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Pastebin {
    public static final String API_POST_LINK = "https://pastebin.com/api/api_post.php";
    public static final String API_LOGIN_LINK = "https://pastebin.com/api/api_login.php";
    public static final String API_SCRAPING_LINK = "https://scrape.pastebin.com/api_scraping.php";
    public static final String SCRAPE_PASTE_METADATA_URL = "https://scrape.pastebin.com/api_scrape_item_meta.php";

    public static String getContents(String pasteKey) {
        return PastebinLink.getContents(pasteKey);
    }

    public static URL pastePaste(String developerKey, String contents) throws PasteException {
        return Pastebin.pastePaste(developerKey, contents, null);
    }

    public static URL pastePaste(String developerKey, String contents, String title) throws PasteException {
        return Pastebin.newPaste(developerKey, contents, title).paste().getLink();
    }

    public static PastebinPaste newPaste(String developerKey, String contents, String title) {
        PastebinPaste paste = new PastebinPaste(developerKey, contents);
        paste.setPasteTitle(title);
        return paste;
    }

    public static PastebinPaste newPaste(String developerKey, String contents) {
        return Pastebin.newPaste(developerKey, contents, null);
    }

    public static PastebinLink[] getTrending(String developerKey) throws ParseException {
        if (developerKey == null || developerKey.isEmpty()) {
            throw new IllegalArgumentException("Developer key can't be null or empty.");
        }
        Post post = new Post();
        post.put("api_dev_key", developerKey);
        post.put("api_option", "trends");
        String response = Web.getContents(API_POST_LINK, post);
        if (response.startsWith("<paste>")) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                response = "<dummy>" + response + "</dummy>";
                Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))));
                doc.getDocumentElement().normalize();
                NodeList nodes = doc.getElementsByTagName("paste");
                ArrayList<PastebinLink> pastes = new ArrayList<PastebinLink>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String pasteFormat = XMLUtils.getText(element, "paste_format_short");
                    String title = XMLUtils.getText(element, "paste_title");
                    int visibility = Integer.parseInt(XMLUtils.getText(element, "paste_private"));
                    int hits = Integer.parseInt(XMLUtils.getText(element, "paste_hits"));
                    long expireDate = Long.parseLong(XMLUtils.getText(element, "paste_expire_date"));
                    long pasteDate = Long.parseLong(XMLUtils.getText(element, "paste_date"));
                    URL pasteURL = new URL(XMLUtils.getText(element, "paste_url"));
                    PastebinPaste paste = new PastebinPaste();
                    paste.setPasteFormat(pasteFormat);
                    paste.setPasteTitle(title);
                    paste.setVisibility(visibility);
                    paste.setPasteExpireDate(expireDate == 0L ? PasteExpireDate.NEVER : PasteExpireDate.getExpireDate((int)(expireDate - pasteDate)));
                    PastebinLink pastebinLink = new PastebinLink(paste, pasteURL, new Date(pasteDate * 1000L));
                    pastebinLink.setHits(hits);
                    pastes.add(pastebinLink);
                }
                return pastes.toArray(new PastebinLink[pastes.size()]);
            }
            catch (Exception e) {
                throw new ParseException("Failed to parse pastes: " + e.getMessage());
            }
        }
        throw new ParseException("Failed to parse paste: " + response);
    }

    public static PastebinLink[] getMostRecent(Post post) throws ParseException {
        String response;
        String url = API_SCRAPING_LINK;
        if (post != null && !post.getPost().isEmpty()) {
            url = url + "?" + post.getPost();
        }
        if ((response = Web.getContents(url)) == null || response.isEmpty() || response.charAt(0) != '[' || response.charAt(response.length() - 1) != ']') {
            throw new ParseException("Failed to parse pastes: " + response);
        }
        ArrayList<Map<String, Object>> listData = Pastebin.getListJSonData(response);
        ArrayList<PastebinLink> listPastebinLink = new ArrayList<PastebinLink>();
        for (Map<String, Object> tempMap : listData) {
            PastebinLink pastebinLink = null;
            try {
                pastebinLink = Pastebin.jSonMapToPastebinLink(tempMap);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (pastebinLink == null) continue;
            listPastebinLink.add(pastebinLink);
        }
        return listPastebinLink.toArray(new PastebinLink[listPastebinLink.size()]);
    }

    private static PastebinLink jSonMapToPastebinLink(Map<String, Object> tempMap) throws MalformedURLException {
        PastebinPaste pastebinPaste = new PastebinPaste();
        pastebinPaste.setPasteFormat(tempMap.get("syntax").toString());
        String pasteTitle = tempMap.get("title").toString();
        pastebinPaste.setPasteTitle(pasteTitle == null ? "" : pasteTitle);
        String pasteAuthor = tempMap.get("user").toString();
        pastebinPaste.setPasteAuthor(pasteAuthor == null ? "" : pasteAuthor);
        long pasteExpireDate = Long.parseLong(tempMap.get("expire").toString());
        long pasteDate = Long.parseLong(tempMap.get("date").toString());
        pastebinPaste.setPasteExpireDate(pasteExpireDate == 0L ? PasteExpireDate.NEVER : PasteExpireDate.getExpireDate((int)(pasteExpireDate - pasteDate)));
        pastebinPaste.setVisibility(0);
        PastebinLink pastebinLink = null;
        pastebinLink = new PastebinLink(pastebinPaste, new URL(tempMap.get("full_url").toString()), new Date(pasteDate * 1000L));
        Object hits = tempMap.get("hits");
        String hitsText = hits == null ? "" : hits.toString();
        pastebinLink.setHits(!hitsText.isEmpty() ? Integer.parseInt(hitsText) : 0);
        return pastebinLink;
    }

    private static ArrayList<Map<String, Object>> getListJSonData(String response) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ArrayList data = (ArrayList)mapper.readValue(response, (TypeReference)new TypeReference<ArrayList<Map<String, Object>>>(){});
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PastebinLink getPaste(String key) throws ParseException {
        String url = SCRAPE_PASTE_METADATA_URL + key;
        String response = Web.getContents(url);
        if (response == null || response.isEmpty() || response.charAt(0) != '[' || response.charAt(response.length() - 1) != ']') {
            throw new ParseException("Failed to parse paste: " + response);
        }
        ArrayList<Map<String, Object>> listData = Pastebin.getListJSonData(response);
        Map<String, Object> tempMap = listData.get(0);
        PastebinLink pastebinLink = null;
        try {
            pastebinLink = Pastebin.jSonMapToPastebinLink(tempMap);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return pastebinLink;
    }
}

