/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.TriplePattern;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.PlainLiteralImpl;

public class TriplePatternImpl
implements TriplePattern {
    private ResourceOrVariable subject;
    private UriOrVariable predicate;
    private NodeOrVariable object;
    public SPO extract;

    public TriplePatternImpl(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TriplePatternImpl(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object, SPO extract) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.extract = extract;
    }

    public TriplePatternImpl(ResourceOrVariable subject, URI predicate, String object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = new PlainLiteralImpl(object);
    }

    public NodeOrVariable getObject() {
        return this.object;
    }

    public UriOrVariable getPredicate() {
        return this.predicate;
    }

    public ResourceOrVariable getSubject() {
        return this.subject;
    }

    public Node getExtract(Statement statement) {
        switch (this.extract) {
            case SUBJECT: {
                return statement.getSubject();
            }
            case PREDICATE: {
                return statement.getPredicate();
            }
            case OBJECT: {
                return statement.getObject();
            }
        }
        assert (false);
        throw new RuntimeException();
    }

    public boolean equals(Object o) {
        return o instanceof Statement && this.getSubject().equals(((Statement)o).getSubject()) && this.getPredicate().equals(((Statement)o).getPredicate()) && this.getObject().equals(((Statement)o).getObject());
    }

    public int hashCode() {
        return this.object.hashCode() + this.predicate.hashCode() + this.object.hashCode();
    }

    public static TriplePatternImpl createObjectPattern(Resource resource, URI propertyURI) {
        return new TriplePatternImpl((ResourceOrVariable)resource, (UriOrVariable)propertyURI, (NodeOrVariable)Variable.ANY, SPO.OBJECT);
    }

    public static TriplePatternImpl createSubjectPattern(URI propertyURI, Node objectNode) {
        return new TriplePatternImpl((ResourceOrVariable)Variable.ANY, (UriOrVariable)propertyURI, (NodeOrVariable)objectNode, SPO.SUBJECT);
    }

    public boolean matches(Statement statement) {
        boolean matchesSubject = statement.getSubject().equals(this.getSubject()) || this.getSubject() instanceof Variable;
        boolean matchesPredicate = statement.getPredicate().equals(this.getPredicate()) || this.getPredicate() instanceof Variable;
        boolean matchesObject = statement.getObject().equals(this.getObject()) || this.getObject() instanceof Variable;
        return matchesSubject && matchesPredicate && matchesObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SPO {
        SUBJECT,
        PREDICATE,
        OBJECT;

    }
}

