/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class ConcurrentInitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getLogger() throws InterruptedException, BrokenBarrierException, ExecutionException {
        int i;
        FutureTask[] tasks = new FutureTask[10 + Runtime.getRuntime().availableProcessors() * 2];
        CyclicBarrier barrier = new CyclicBarrier(tasks.length + 1);
        try {
            for (i = 0; i < tasks.length; ++i) {
                tasks[i] = new FutureTask<ILoggerFactory>(new GetLogger(barrier));
                new Thread(tasks[i]).start();
            }
            barrier.await();
        }
        finally {
            barrier.reset();
        }
        for (i = 0; i < tasks.length; ++i) {
            Assert.assertFalse((String)(i + "=" + ((ILoggerFactory)tasks[i].get()).getClass().getName()), (boolean)(tasks[i].get() instanceof SubstituteLoggerFactory));
            Assert.assertTrue((String)(i + "=" + ((ILoggerFactory)tasks[i].get()).getClass().getName()), (boolean)(tasks[i].get() instanceof NOPLoggerFactory));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetLogger
    implements Callable<ILoggerFactory> {
        private CyclicBarrier barrier;

        public GetLogger(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        @Override
        public ILoggerFactory call() throws InterruptedException, BrokenBarrierException {
            this.barrier.await();
            return LoggerFactory.getILoggerFactory();
        }
    }
}

