/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class SubstituteLoggerFactoryTest
extends TestCase {
    private SubstituteLoggerFactory factory = new SubstituteLoggerFactory();

    public void testFactory() {
        Logger log = this.factory.getLogger("foo");
        SubstituteLoggerFactoryTest.assertNotNull((Object)log);
        Logger log2 = this.factory.getLogger("foo");
        SubstituteLoggerFactoryTest.assertTrue((String)"Loggers with same name must be same", (log == log2 ? 1 : 0) != 0);
    }

    public void testLoggerNameList() {
        this.factory.getLogger("foo1");
        this.factory.getLogger("foo2");
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo1", "foo2"));
        HashSet actualNames = new HashSet(this.factory.getLoggerNames());
        SubstituteLoggerFactoryTest.assertEquals(expectedNames, actualNames);
    }

    public void testLoggers() {
        this.factory.getLogger("foo1");
        this.factory.getLogger("foo2");
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo1", "foo2"));
        HashSet<String> actualNames = new HashSet<String>();
        for (SubstituteLogger slog : this.factory.getLoggers()) {
            actualNames.add(slog.getName());
        }
        SubstituteLoggerFactoryTest.assertEquals(expectedNames, actualNames);
    }
}

