/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.switchyard.policy.Policy;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.policy.TransactionPolicy;

public final class PolicyFactory {
    private static Set<Policy> _policies = new HashSet<Policy>();

    private PolicyFactory() {
    }

    public static Policy getPolicy(final String name) throws Exception {
        for (Policy p : _policies) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return new Policy(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean supports(Policy.PolicyType type) {
                return true;
            }

            @Override
            public boolean isCompatibleWith(Policy target) {
                return true;
            }

            @Override
            public Policy getPolicyDependency() {
                return null;
            }
        };
    }

    public static Set<Policy> getAllAvailablePolicies() {
        return Collections.unmodifiableSet(_policies);
    }

    public static Set<Policy> getAvailableInteractionPolicies() {
        HashSet<Policy> interactions = new HashSet<Policy>();
        for (Policy p : _policies) {
            if (!p.supports(Policy.PolicyType.INTERACTION)) continue;
            interactions.add(p);
        }
        return Collections.unmodifiableSet(interactions);
    }

    public static Set<Policy> getAvailableImplementationPolicies() {
        HashSet<Policy> implementations = new HashSet<Policy>();
        for (Policy p : _policies) {
            if (!p.supports(Policy.PolicyType.IMPLEMENTATION)) continue;
            implementations.add(p);
        }
        return Collections.unmodifiableSet(implementations);
    }

    static {
        _policies.addAll(Arrays.asList(TransactionPolicy.values()));
        _policies.addAll(Arrays.asList(SecurityPolicy.values()));
    }
}

