/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.extensions.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.SwitchYardException;
import org.switchyard.annotations.OperationTypes;
import org.switchyard.common.type.Classes;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.metadata.ServiceOperation;

public final class JavaService
extends BaseService {
    public static final String TYPE = "java";
    private Class<?> _serviceInterface;

    private JavaService(Set<ServiceOperation> operations, Class<?> serviceInterface) {
        super(operations, TYPE);
        this._serviceInterface = serviceInterface;
    }

    public static JavaService fromClass(Class<?> serviceInterface) {
        HashSet<ServiceOperation> ops = new HashSet<ServiceOperation>();
        for (Method m : serviceInterface.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length > 1) {
                throw new RuntimeException("Service operations on a Java interface must have exactly one parameter.");
            }
            OperationTypeQNames operationTypeNames = new OperationTypeQNames(m);
            if (m.getReturnType().equals(Void.TYPE)) {
                ops.add((ServiceOperation)new InOnlyOperation(m.getName(), operationTypeNames.in()));
                continue;
            }
            ops.add((ServiceOperation)new InOutOperation(m.getName(), operationTypeNames.in(), operationTypeNames.out(), operationTypeNames.fault()));
        }
        return new JavaService(ops, serviceInterface);
    }

    public Class<?> getJavaInterface() {
        return this._serviceInterface;
    }

    public static Class<?> parseType(QName type) {
        if (type == null) {
            return null;
        }
        String localPart = type.getLocalPart();
        int indexOf = localPart.indexOf(58);
        if (indexOf != -1) {
            return Classes.forName((String)localPart.substring(indexOf + 1));
        }
        return null;
    }

    public static final class OperationTypeQNames {
        private Method _operationMethod;
        private OperationTypes _methodTypeNames;

        public OperationTypeQNames(Method operationMethod) {
            this._operationMethod = operationMethod;
            this._methodTypeNames = operationMethod.getAnnotation(OperationTypes.class);
        }

        public QName in() {
            if (this._operationMethod.getParameterTypes().length > 0) {
                Class<?> inputType = this._operationMethod.getParameterTypes()[0];
                if (this._methodTypeNames != null && this._methodTypeNames.in().length() != 0) {
                    return QName.valueOf(this._methodTypeNames.in());
                }
                return JavaTypes.toMessageType(inputType);
            }
            return null;
        }

        public QName out() {
            if (this._methodTypeNames != null && this._methodTypeNames.out().length() != 0) {
                return QName.valueOf(this._methodTypeNames.out());
            }
            return JavaTypes.toMessageType(this._operationMethod.getReturnType());
        }

        public QName fault() {
            Class<?>[] exceptions = this._operationMethod.getExceptionTypes();
            if (exceptions.length == 0) {
                return null;
            }
            if (exceptions.length > 1) {
                throw new SwitchYardException("Service operations on a Java interface can only throw one type of exception.");
            }
            if (this._methodTypeNames != null && this._methodTypeNames.fault().length() != 0) {
                return QName.valueOf(this._methodTypeNames.fault());
            }
            return JavaTypes.toMessageType(exceptions[0]);
        }
    }
}

