/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.resteasy;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.resteasy.RESTEasyFacet;

@Alias(value="rest-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, RESTEasyFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage RESTEasy service bindings in SwitchYard.")
public class RESTEasyBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a RESTEasy binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=true, name="interfaces", description="A comma seperated list of interface/abstract/empty classes with JAX-RS annotations") String interfaces, @Option(required=false, name="contextPath", description="The context root for this RESTEasy endpoint, defaults to [projectName]") String contextPath, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        RESTEasyBindingModel binding = new RESTEasyBindingModel();
        binding.setInterfaces(interfaces);
        String projectName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getProjectName();
        if (contextPath != null && contextPath.length() > 0) {
            binding.setContextPath(contextPath);
        } else {
            binding.setContextPath(projectName);
        }
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.rest to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a RESTEasy binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="interfaces", description="A comma seperated list of interface/abstract/empty classes with JAX-RS annotations") String interfaces, @Option(required=false, name="address", description="The remote REST enpoints address, defaults to localhost:8080") String address, @Option(required=false, name="contextPath", description="Additional context for the remote RESTEasy endpoint, defaults to [projectName]") String contextPath, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        RESTEasyBindingModel binding = new RESTEasyBindingModel();
        binding.setInterfaces(interfaces);
        if (address != null) {
            binding.setAddress(address);
        }
        String projectName = ((MetadataFacet)this._project.getFacet(MetadataFacet.class)).getProjectName();
        if (contextPath != null) {
            binding.setContextPath(contextPath);
        } else if (address == null) {
            binding.setContextPath(projectName);
        }
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.rest to reference " + referenceName);
    }
}

