/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.common.knowledge.annotation.Mapping;
import org.switchyard.component.common.knowledge.config.model.ActionModel;
import org.switchyard.component.common.knowledge.config.model.ActionsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeSwitchYardScanner;
import org.switchyard.component.common.knowledge.config.model.v1.V1ActionsModel;
import org.switchyard.component.rules.RulesActionType;
import org.switchyard.component.rules.annotation.Execute;
import org.switchyard.component.rules.annotation.FireAllRules;
import org.switchyard.component.rules.annotation.FireUntilHalt;
import org.switchyard.component.rules.annotation.Insert;
import org.switchyard.component.rules.annotation.Rules;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class RulesSwitchYardScanner
extends KnowledgeSwitchYardScanner {
    private static final IsAnnotationPresentFilter EXECUTE_FILTER = new IsAnnotationPresentFilter(Execute.class);
    private static final IsAnnotationPresentFilter INSERT_FILTER = new IsAnnotationPresentFilter(Insert.class);
    private static final IsAnnotationPresentFilter FIRE_ALL_RULES_FILTER = new IsAnnotationPresentFilter(FireAllRules.class);
    private static final IsAnnotationPresentFilter FIRE_UNTIL_HALT_FILTER = new IsAnnotationPresentFilter(FireUntilHalt.class);
    private final IsAnnotationPresentFilter _rulesFilter = new IsAnnotationPresentFilter(Rules.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        ClasspathScanner rulesScanner = new ClasspathScanner((Filter)this._rulesFilter);
        for (URL url : input.getURLs()) {
            rulesScanner.scan(url);
        }
        List rulesClasses = this._rulesFilter.getMatchedTypes();
        for (Class rulesClass : rulesClasses) {
            compositeModel.addComponent(this.scan(rulesClass));
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    public ComponentModel scan(Class<?> rulesClass) throws IOException {
        Rules rules = rulesClass.getAnnotation(Rules.class);
        Class<?> rulesInterface = rules.value();
        if (Rules.UndefinedRulesInterface.class.equals((Object)rulesInterface)) {
            rulesInterface = rulesClass;
        }
        if (!rulesInterface.isInterface()) {
            throw new IOException(rulesInterface.getName() + " is a class. @Rules only allowed on interfaces.");
        }
        String rulesName = Strings.trimToNull((String)rules.name());
        if (rulesName == null) {
            rulesName = rulesInterface.getSimpleName();
        }
        V1ComponentModel componentModel = new V1ComponentModel();
        componentModel.setName(rulesName);
        V1RulesComponentImplementationModel componentImplementationModel = new V1RulesComponentImplementationModel();
        V1ActionsModel actionsModel = new V1ActionsModel("urn:switchyard-component-rules:config:1.0");
        JavaService javaService = JavaService.fromClass(rulesInterface);
        for (Method method : rulesClass.getDeclaredMethods()) {
            ServiceOperation serviceOperation;
            RulesActionType actionType = null;
            String id = null;
            Mapping[] globalMappingAnnotations = null;
            Mapping[] inputMappingAnnotations = null;
            Mapping[] outputMappingAnnotations = null;
            if (EXECUTE_FILTER.matches(method)) {
                actionType = RulesActionType.EXECUTE;
                Execute executeAnnotation = method.getAnnotation(Execute.class);
                globalMappingAnnotations = executeAnnotation.globals();
                inputMappingAnnotations = executeAnnotation.inputs();
                outputMappingAnnotations = executeAnnotation.outputs();
            } else if (INSERT_FILTER.matches(method)) {
                actionType = RulesActionType.INSERT;
                Insert insertAnnotation = method.getAnnotation(Insert.class);
                globalMappingAnnotations = insertAnnotation.globals();
                inputMappingAnnotations = insertAnnotation.inputs();
                outputMappingAnnotations = insertAnnotation.outputs();
            } else if (FIRE_ALL_RULES_FILTER.matches(method)) {
                actionType = RulesActionType.FIRE_ALL_RULES;
                FireAllRules fireAllRulesAnnotation = method.getAnnotation(FireAllRules.class);
                globalMappingAnnotations = fireAllRulesAnnotation.globals();
                inputMappingAnnotations = fireAllRulesAnnotation.inputs();
                outputMappingAnnotations = fireAllRulesAnnotation.outputs();
            } else if (FIRE_UNTIL_HALT_FILTER.matches(method)) {
                actionType = RulesActionType.FIRE_UNTIL_HALT;
                FireUntilHalt fireUntilHaltAnnotation = method.getAnnotation(FireUntilHalt.class);
                globalMappingAnnotations = fireUntilHaltAnnotation.globals();
                inputMappingAnnotations = fireUntilHaltAnnotation.inputs();
                outputMappingAnnotations = fireUntilHaltAnnotation.outputs();
                id = Strings.trimToNull((String)fireUntilHaltAnnotation.id());
            }
            if (actionType == null || (serviceOperation = javaService.getOperation(method.getName())) == null) continue;
            V1RulesActionModel actionModel = new V1RulesActionModel();
            actionModel.setId(id);
            actionModel.setOperation(serviceOperation.getName());
            actionModel.setType(actionType);
            actionModel.setGlobals(this.toMappingsModel(globalMappingAnnotations, "urn:switchyard-component-rules:config:1.0", "globals"));
            actionModel.setInputs(this.toMappingsModel(inputMappingAnnotations, "urn:switchyard-component-rules:config:1.0", "inputs"));
            actionModel.setOutputs(this.toMappingsModel(outputMappingAnnotations, "urn:switchyard-component-rules:config:1.0", "outputs"));
            actionsModel.addAction((ActionModel)actionModel);
        }
        if (!actionsModel.getActions().isEmpty()) {
            componentImplementationModel.setActions((ActionsModel)actionsModel);
        }
        componentImplementationModel.setChannels(this.toChannelsModel(rules.channels(), "urn:switchyard-component-rules:config:1.0", (ComponentModel)componentModel));
        componentImplementationModel.setListeners(this.toListenersModel(rules.listeners(), "urn:switchyard-component-rules:config:1.0"));
        componentImplementationModel.setLoggers(this.toLoggersModel(rules.loggers(), "urn:switchyard-component-rules:config:1.0"));
        componentImplementationModel.setManifest(this.toManifestModel(rules.manifest(), "urn:switchyard-component-rules:config:1.0"));
        componentImplementationModel.setProperties(this.toPropertiesModel(rules.properties(), "urn:switchyard-component-rules:config:1.0"));
        componentModel.setImplementation((ComponentImplementationModel)componentImplementationModel);
        V1ComponentServiceModel componentServiceModel = new V1ComponentServiceModel();
        V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
        interfaceModel.setInterface(rulesInterface.getName());
        componentServiceModel.setInterface((InterfaceModel)interfaceModel);
        componentServiceModel.setName(rulesName);
        componentModel.addService((ComponentServiceModel)componentServiceModel);
        return componentModel;
    }
}

