/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.soap;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.common.net.SocketAddr;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;
import org.switchyard.tools.forge.soap.SOAPFacet;

@Alias(value="soap-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, SOAPFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage SOAP service bindings in SwitchYard.")
public class SOAPBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a SOAP binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=true, name="wsdl", description="URL or package-local path to the endpoint WSDL") String wsdlLocation, @Option(required=false, name="socketAddr", description="Bind to this ip+port for SOAP endpoints") String socketAddr, @Option(required=false, name="portType", description="portType to use for interface definition") String portType, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        if (portType != null) {
            V1InterfaceModel intf = new V1InterfaceModel("wsdl");
            intf.setInterface(wsdlLocation + "#wsdl.porttype(" + portType + ")");
            service.setInterface((InterfaceModel)intf);
        }
        SOAPBindingModel binding = new SOAPBindingModel();
        binding.setWsdl(wsdlLocation);
        if (socketAddr != null) {
            binding.setSocketAddr(new SocketAddr(socketAddr));
        }
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.soap to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a SOAP binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="wsdl", description="URL or package-local path to the endpoint WSDL") String wsdlLocation, @Option(required=false, name="portName", description="Port name in WSDL") String portName, @Option(required=false, name="portType", description="portType to use for interface definition") String portType, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        if (portType != null) {
            V1InterfaceModel intf = new V1InterfaceModel("wsdl");
            intf.setInterface(wsdlLocation + "#wsdl.porttype(" + portType + ")");
            reference.setInterface((InterfaceModel)intf);
        }
        SOAPBindingModel binding = new SOAPBindingModel();
        binding.setWsdl(wsdlLocation);
        if (portName != null) {
            binding.setPort(new PortName(portName));
        }
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.soap to reference " + referenceName);
    }
}

