/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard;

import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.TestCase;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;

public class MockHandler
extends BaseHandler {
    private final LinkedBlockingQueue<Exchange> _messages = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Exchange> _faults = new LinkedBlockingQueue();
    private static final int DEFAULT_SLEEP_MS = 100;
    private static final int DEFAULT_WAIT_TIMEOUT = 5000;
    private long _waitTimeout = 5000L;
    private boolean _forwardInToOut = false;
    private boolean _forwardInToFault = false;

    public long getWaitTimeout() {
        return this._waitTimeout;
    }

    public void setWaitTimeout(long waitTimeout) {
        this._waitTimeout = waitTimeout;
    }

    public LinkedBlockingQueue<Exchange> getMessages() {
        return this._messages;
    }

    public LinkedBlockingQueue<Exchange> getFaults() {
        return this._faults;
    }

    public MockHandler forwardInToOut() {
        this._forwardInToOut = true;
        this._forwardInToFault = false;
        return this;
    }

    public MockHandler forwardInToFault() {
        this._forwardInToOut = false;
        this._forwardInToFault = true;
        return this;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        this._messages.offer(exchange);
        if (this._forwardInToOut) {
            exchange.send(exchange.getMessage().copy());
        } else if (this._forwardInToFault) {
            exchange.sendFault(exchange.createMessage());
        }
    }

    public void handleFault(Exchange exchange) {
        this._faults.offer(exchange);
    }

    public MockHandler waitForOKMessage() {
        this.waitFor(this._messages, 1);
        return this;
    }

    public MockHandler waitForFaultMessage() {
        this.waitFor(this._faults, 1);
        return this;
    }

    private void waitFor(LinkedBlockingQueue<Exchange> eventQueue, int numMessages) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + this._waitTimeout) {
            if (eventQueue.size() >= numMessages) {
                return;
            }
            this.sleep();
        }
        TestCase.fail((String)("Timed out waiting on event queue length to be " + numMessages + " or greater."));
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            TestCase.fail((String)("Failed to sleep: " + e.getMessage()));
        }
    }
}

