/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Message;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class BaseTransformerRegistryTest {
    private TransformerRegistry _registry;

    @Before
    public void setUp() throws Exception {
        this._registry = new BaseTransformerRegistry();
    }

    @Test
    public void testAddGetTransformer() {
        QName fromName = new QName("a");
        QName toName = new QName("b");
        BaseTransformer<String, Integer> t = new BaseTransformer<String, Integer>(fromName, toName){

            public Integer transform(String from) {
                return null;
            }
        };
        this._registry.addTransformer((Transformer)t);
        Assert.assertEquals((Object)t, (Object)this._registry.getTransformer(fromName, toName));
    }

    @Test
    public void test_fallbackTransformerComparator_resolvable() {
        ArrayList<BaseTransformerRegistry.JavaSourceFallbackTransformer> transformersList = new ArrayList<BaseTransformerRegistry.JavaSourceFallbackTransformer>();
        transformersList.add(new BaseTransformerRegistry.JavaSourceFallbackTransformer(C.class, null));
        transformersList.add(new BaseTransformerRegistry.JavaSourceFallbackTransformer(E.class, null));
        transformersList.add(new BaseTransformerRegistry.JavaSourceFallbackTransformer(D.class, null));
        transformersList.add(new BaseTransformerRegistry.JavaSourceFallbackTransformer(A.class, null));
        transformersList.add(new BaseTransformerRegistry.JavaSourceFallbackTransformer(B.class, null));
        BaseTransformerRegistry.JavaSourceFallbackTransformerComparator comparator = new BaseTransformerRegistry.JavaSourceFallbackTransformerComparator();
        Collections.sort(transformersList, comparator);
        Assert.assertTrue((((BaseTransformerRegistry.JavaSourceFallbackTransformer)transformersList.get(0)).getJavaType() == E.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseTransformerRegistry.JavaSourceFallbackTransformer)transformersList.get(1)).getJavaType() == D.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseTransformerRegistry.JavaSourceFallbackTransformer)transformersList.get(2)).getJavaType() == C.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseTransformerRegistry.JavaSourceFallbackTransformer)transformersList.get(3)).getJavaType() == B.class ? 1 : 0) != 0);
        Assert.assertTrue((((BaseTransformerRegistry.JavaSourceFallbackTransformer)transformersList.get(4)).getJavaType() == A.class ? 1 : 0) != 0);
    }

    @Test
    public void test_getFallbackTransformer_resolvable() {
        this.addTransformer(B.class);
        this.addTransformer(C.class);
        this.addTransformer(A.class);
        Transformer transformer = this._registry.getTransformer(this.getType(D.class), new QName("targetX"));
        Assert.assertNull((Object)transformer);
        transformer = this._registry.getTransformer(this.getType(D.class), new QName("target1"));
        Assert.assertNotNull((Object)transformer);
        Assert.assertEquals((Object)this.getType(C.class), (Object)transformer.getFrom());
        transformer = this._registry.getTransformer(this.getType(D.class), new QName("target1"));
    }

    @Test
    public void testGetTransformSequence() {
        QName A2 = new QName("a");
        QName B2 = new QName("b");
        QName C2 = new QName("c");
        BaseTransformerRegistry _registry = new BaseTransformerRegistry();
        _registry.addTransformer((Transformer)new TestTransformer2(A2, B2));
        _registry.addTransformer((Transformer)new TestTransformer2(B2, C2));
        TransformSequence transformSequence = _registry.getTransformSequence(A2, C2);
        DefaultMessage message = new DefaultMessage().setContent((Object)A2);
        transformSequence.apply((Message)message, (TransformerRegistry)_registry);
        Assert.assertEquals((Object)C2, (Object)message.getContent());
    }

    private void addTransformer(Class<?> type) {
        QName fromType = this.getType(type);
        QName toType = new QName("target1");
        this._registry.addTransformer((Transformer)new TestTransformer(fromType, toType));
    }

    private QName getType(Class<?> type) {
        return JavaTypes.toMessageType(type);
    }

    private class TestTransformer2
    extends BaseTransformer {
        private QName from;
        private QName to;

        private TestTransformer2(QName from, QName to) {
            super(from, to);
            this.from = from;
            this.to = to;
        }

        public Object transform(Object from) {
            Assert.assertEquals((Object)this.from, (Object)from);
            return this.to;
        }
    }

    public class TestTransformer
    extends BaseTransformer {
        public TestTransformer(QName from, QName to) {
            super(from, to);
        }

        public Object transform(Object from) {
            return from;
        }
    }

    public static interface I {
    }

    public class E
    extends D {
    }

    public class D
    extends C
    implements I {
    }

    public class C
    extends B {
    }

    public class B
    extends A {
    }

    public class A {
    }
}

