/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Map;
import javax.activation.DataSource;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Message;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.DummyDS;

public class DefaultMessageTest {
    private Message _message;

    @Before
    public void setUp() {
        this._message = new DefaultMessage();
    }

    @Test
    public void testAddAttachment() throws Exception {
        this._message.addAttachment("attach1", (DataSource)new DummyDS("attach1", "text/xml"));
        Assert.assertNotNull((Object)this._message.getAttachment("attach1"));
    }

    @Test
    public void testRemoveAttachment() throws Exception {
        this._message.addAttachment("attach1", (DataSource)new DummyDS("attach1", "text/xml"));
        Assert.assertNotNull((Object)this._message.getAttachment("attach1"));
        this._message.removeAttachment("attach1");
        Assert.assertNull((Object)this._message.getAttachment("attach1"));
    }

    @Test
    public void testGetAttachmentMap() throws Exception {
        this._message.addAttachment("attach1", (DataSource)new DummyDS("attach1", "text/xml"));
        this._message.addAttachment("attach2", (DataSource)new DummyDS("attach1", "text/xml"));
        Map attachments = this._message.getAttachmentMap();
        Assert.assertTrue((boolean)attachments.containsKey("attach1"));
        Assert.assertTrue((boolean)attachments.containsKey("attach2"));
        attachments.remove("attach1");
        Assert.assertNotNull((Object)this._message.getAttachment("attach1"));
    }

    @Test
    public void testContent() throws Exception {
        String message = "Hello There!";
        this._message.setContent((Object)"Hello There!");
        Assert.assertEquals((Object)"Hello There!", (Object)this._message.getContent());
        String content = (String)this._message.getContent(String.class);
        Assert.assertEquals((String)"Hello There!", (String)content);
    }
}

