/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.validate;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;

public class BaseValidatorTest {
    @Test
    public void testGetName_default_with_generics() {
        BaseValidator<String> strv = new BaseValidator<String>(){

            public ValidationResult validate(String obj) {
                if (obj != null) {
                    return 1.validResult();
                }
                return 1.invalidResult((String)"obj == null");
            }
        };
        Assert.assertEquals((String)"java:java.lang.String", (String)strv.getName().toString());
    }

    @Test
    public void testGetName_default_without_generics() {
        BaseValidator strv = new BaseValidator(){

            public ValidationResult validate(Object obj) {
                if (obj != null) {
                    return 2.validResult();
                }
                return 2.invalidResult((String)"obj == null");
            }
        };
        Assert.assertEquals((String)"java:java.lang.Object", (String)strv.getName().toString());
    }

    @Test
    public void testGetName_specified_with_generics() {
        QName name = new QName("string1");
        BaseValidator<String> strv = new BaseValidator<String>(name){

            public ValidationResult validate(String obj) {
                if (obj != null) {
                    return 3.validResult();
                }
                return 3.invalidResult((String)"obj == null");
            }
        };
        Assert.assertEquals((Object)name, (Object)strv.getName());
    }

    @Test
    public void testGetName_specified_without_generics() {
        QName name = new QName("string1");
        BaseValidator strv = new BaseValidator(name){

            public ValidationResult validate(Object obj) {
                if (obj != null) {
                    return 4.validResult();
                }
                return 4.invalidResult((String)"obj == null");
            }
        };
        Assert.assertEquals((Object)name, (Object)strv.getName());
    }
}

