/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tests;

import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.common.version.Queries;
import org.switchyard.common.version.Query;
import org.switchyard.common.version.QueryType;
import org.switchyard.common.version.Version;
import org.switchyard.common.version.VersionFactory;
import org.switchyard.common.version.Versions;

public class VersionTest {
    @Test
    public void testPrint() {
        Versions.printSwitchYardNotification();
        Versions.printSwitchYardVersions();
    }

    @Test
    public void testEquals() {
        VersionFactory factory = VersionFactory.instance();
        Version expected = factory.getVersion(Queries.Projects.SWITCHYARD_COMMON);
        Version actual = factory.getVersion(Queries.Projects.create((String)"org.switchyard", (String)"switchyard-common"));
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = factory.getVersion(new Query[]{Queries.Projects.SWITCHYARD, new Query(QueryType.PROJECT_ARTIFACT_ID, "switchyard-common")});
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = factory.getVersion(new Query[]{new Query(QueryType.SPECIFICATION_TITLE, "SwitchYard: Common")});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCompare() {
        VersionFactory factory = VersionFactory.instance();
        Version api = factory.getVersion(Queries.Projects.SWITCHYARD_API);
        Version common = factory.getVersion(Queries.Projects.SWITCHYARD_COMMON);
        TreeSet<Version> set = new TreeSet<Version>();
        set.add(common);
        set.add(api);
        Iterator iter = set.iterator();
        Assert.assertTrue((String)"1st version should be api", (iter.next() == api ? 1 : 0) != 0);
        Assert.assertTrue((String)"2nd version should be common", (iter.next() == common ? 1 : 0) != 0);
    }
}

