/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.switchyard.security.credential.Credential;

public final class SecurityContext
implements Serializable {
    private static final long serialVersionUID = -3501287028169238578L;
    private static final ThreadLocal<SecurityContext> THREAD_LOCAL = new ThreadLocal();
    private final Set<Credential> _credentials = Collections.synchronizedSet(new HashSet());
    private final Map<String, Subject> _domainsToSubjects = Collections.synchronizedMap(new HashMap());

    private SecurityContext() {
    }

    public Set<Credential> getCredentials() {
        return this._credentials;
    }

    public <T extends Credential> Set<T> getCredentials(Class<T> clazz) {
        HashSet<T> matches = new HashSet<T>();
        for (Credential credential : this.getCredentials()) {
            if (credential == null || !clazz.isAssignableFrom(credential.getClass())) continue;
            matches.add(clazz.cast(credential));
        }
        return matches;
    }

    public synchronized Subject getSubject(String domain) {
        Subject subject = this._domainsToSubjects.get(domain);
        if (subject == null) {
            subject = new Subject();
            this._domainsToSubjects.put(domain, subject);
        }
        return subject;
    }

    public String toString() {
        return "SecurityContext [credentials=" + this._credentials + ", domainsToSubjects=" + this._domainsToSubjects + "]";
    }

    public static SecurityContext get() {
        return SecurityContext.get(true);
    }

    public static synchronized SecurityContext get(boolean create) {
        SecurityContext securityCtx = THREAD_LOCAL.get();
        if (securityCtx == null && create) {
            securityCtx = new SecurityContext();
            THREAD_LOCAL.set(securityCtx);
        }
        return securityCtx;
    }

    public static void clear() {
        THREAD_LOCAL.set(null);
    }
}

