/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extract;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.credential.extract.AuthorizationHeaderCredentialsExtractor;
import org.switchyard.security.credential.extract.CredentialsExtractor;
import org.switchyard.security.principal.User;

public class ServletRequestCredentialsExtractor
implements CredentialsExtractor<ServletRequest> {
    @Override
    public Set<Credential> extractCredentials(ServletRequest source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source != null) {
            credentials.add(new ConfidentialityCredential(source.isSecure()));
            if (source instanceof HttpServletRequest) {
                String charsetName;
                String remoteUser;
                HttpServletRequest request = (HttpServletRequest)source;
                Principal userPrincipal = request.getUserPrincipal();
                if (userPrincipal != null) {
                    credentials.add(new PrincipalCredential(userPrincipal, true));
                }
                if ((remoteUser = request.getRemoteUser()) != null) {
                    credentials.add(new PrincipalCredential(new User(remoteUser), true));
                }
                AuthorizationHeaderCredentialsExtractor ahce = (charsetName = source.getCharacterEncoding()) != null ? new AuthorizationHeaderCredentialsExtractor(charsetName) : new AuthorizationHeaderCredentialsExtractor();
                credentials.addAll(ahce.extractCredentials(request.getHeader("Authorization")));
            }
        }
        return credentials;
    }
}

