/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.switchyard.ServiceSecurity;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.SecurityProvider;
import org.switchyard.security.callback.handler.NamePasswordCallbackHandler;
import org.switchyard.security.callback.handler.SwitchYardCallbackHandler;

public class JaasSecurityProvider
extends SecurityProvider {
    private static final Logger LOGGER = Logger.getLogger(JaasSecurityProvider.class);

    @Override
    public boolean authenticate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String domain;
        CallbackHandler ch;
        boolean success = false;
        Class<NamePasswordCallbackHandler> ch_clazz = serviceSecurity.getCallbackHandler();
        if (ch_clazz == null) {
            ch_clazz = NamePasswordCallbackHandler.class;
        }
        if ((ch = (CallbackHandler)Construction.construct(ch_clazz)) instanceof SwitchYardCallbackHandler) {
            SwitchYardCallbackHandler sych = (SwitchYardCallbackHandler)ch;
            sych.setProperties(serviceSecurity.getProperties());
            sych.setCredentials(securityContext.getCredentials());
        }
        if ((domain = Strings.trimToNull((String)serviceSecurity.getModuleName())) == null) {
            domain = "other";
        }
        Subject subject = securityContext.getSubject(domain);
        try {
            new LoginContext(domain, subject, ch).login();
            success = true;
        }
        catch (LoginException le) {
            LOGGER.error((Object)("authenticate LoginException: " + le.getMessage()), (Throwable)le);
        }
        return success;
    }
}

