/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.junit.Assert;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.SimpleTestDeployment;
import org.switchyard.test.mixins.AbstractTestMixIn;
import org.switchyard.test.mixins.NamingMixIn;

@MixInDependencies(required={NamingMixIn.class})
public class CDIMixIn
extends AbstractTestMixIn {
    private static final String BINDING_CONTEXT = "java:comp";
    private static final String BEAN_MANAGER_NAME = "BeanManager";
    private Weld _weld;
    private WeldContainer _weldContainer;
    private AbstractDeployment _simpleCdiDeployment;

    @Override
    public void initialize() {
        super.initialize();
        this._weld = new Weld();
        this._weldContainer = this._weld.initialize();
        this._weldContainer.event().select(ContainerInitialized.class, new Annotation[0]).fire((Object)new ContainerInitialized());
        try {
            Context ctx = (Context)new InitialContext().lookup(BINDING_CONTEXT);
            ctx.rebind(BEAN_MANAGER_NAME, (Object)this.getBeanManager());
        }
        catch (NamingException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to bind BeanManager into 'java:comp'.");
        }
    }

    @Override
    public void before(AbstractDeployment deployment) {
        if (deployment instanceof SimpleTestDeployment) {
            Class simpleCdiDeploymentType = Classes.forName((String)"org.switchyard.component.bean.internal.SimpleCDIDeployment", this.getClass());
            if (simpleCdiDeploymentType == null) {
                Assert.fail((String)"Failed to locate the SimpleCDIDeployment class on the classpath.  Module must include the SwitchYard Bean Component as one of its depedencies.");
            }
            try {
                this._simpleCdiDeployment = (AbstractDeployment)simpleCdiDeploymentType.newInstance();
                this._simpleCdiDeployment.setParentDeployment(deployment);
                ServiceDomain domain = new ServiceDomainManager().createDomain();
                this._simpleCdiDeployment.init(domain, this.getTestKit().getActivators());
                this._simpleCdiDeployment.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to manually deploy Bean Service.  Exception: " + e.getMessage()));
            }
        }
    }

    public BeanManager getBeanManager() {
        return this._weldContainer.getBeanManager();
    }

    public Bean<?> getBean(String name) {
        BeanManager beanManager = this.getBeanManager();
        Set beans = beanManager.getBeans(name);
        if (beans != null && !beans.isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        throw new IllegalStateException("Unable to find CDI bean @Named '" + name + "'.  \n\t - Check for a typo in the name. \n\t - Make sure the Class is annotated with the @Name annotation.");
    }

    public Bean getBean(Class<?> type) {
        BeanManager beanManager = this.getBeanManager();
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans != null && !beans.isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        throw new IllegalStateException("Unable to find CDI bean of type '" + type.getName() + "'.");
    }

    public Object getObject(String name) {
        return this.createBeanInstance(this.getBean(name));
    }

    public <T> T getObject(String name, Class<T> type) {
        return type.cast(this.getObject(name));
    }

    public <T> T getObject(Class<T> type) {
        return type.cast(this.createBeanInstance(this.getBean(type)));
    }

    @Override
    public void after(AbstractDeployment deployment) {
        if (this._simpleCdiDeployment != null) {
            this._simpleCdiDeployment.stop();
            this._simpleCdiDeployment.destroy();
        }
    }

    @Override
    public synchronized void uninitialize() {
        if (this._weld != null) {
            this._weld.shutdown();
            this._weld = null;
        } else {
            Thread.dumpStack();
        }
        super.uninitialize();
    }

    private Object createBeanInstance(Bean<?> bean) {
        BeanManager beanManager = this.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        return beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
    }
}

