/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.internal.smooks;

import javax.xml.namespace.QName;
import org.milyn.Smooks;
import org.milyn.container.ApplicationContext;
import org.milyn.javabean.binding.model.ModelSet;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.SmooksTransformModel;
import org.switchyard.transform.internal.smooks.SmooksTransformer;
import org.switchyard.transform.internal.smooks.XMLBindingTransformer;

public final class SmooksTransformFactory {
    private SmooksTransformFactory() {
    }

    public static Transformer newTransformer(SmooksTransformModel model) {
        Smooks smooks;
        String transformType = model.getTransformType();
        String config = model.getConfig();
        QName from = model.getFrom();
        QName to = model.getTo();
        if (transformType == null || transformType.trim().length() == 0) {
            throw new RuntimeException("Invalid Smooks configuration model.  null or empty 'type' specification.");
        }
        if (config == null || config.trim().length() == 0) {
            throw new RuntimeException("Invalid Smooks configuration model.  null or empty 'config' specification.");
        }
        if (from == null) {
            throw new RuntimeException("Invalid Smooks configuration model.  null or 'from' specification.");
        }
        if (to == null) {
            throw new RuntimeException("Invalid Smooks configuration model.  null or 'to' specification.");
        }
        SmooksTransformationType transformationType = SmooksTransformationType.valueOf(transformType);
        try {
            smooks = new Smooks(config);
            smooks.createExecutionContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Smooks instance for config '" + config + "'.", e);
        }
        if (transformationType == SmooksTransformationType.JAVA2XML) {
            return SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.JAVA2XML);
        }
        if (transformationType == SmooksTransformationType.XML2JAVA) {
            return SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.XML2JAVA);
        }
        if (transformationType == SmooksTransformationType.SMOOKS) {
            return new SmooksTransformer(from, to, smooks, model);
        }
        throw new RuntimeException("Unhandled Smooks transformation type '" + (Object)((Object)transformationType) + "'.");
    }

    private static Transformer newXMLBindingTransformer(QName from, QName to, Smooks smooks, XMLBindingTransformer.BindingDirection direction) {
        ModelSet beanModel = ModelSet.get((ApplicationContext)smooks.getApplicationContext());
        if (beanModel != null && !beanModel.getModels().isEmpty()) {
            return new XMLBindingTransformer(from, to, smooks, beanModel, direction);
        }
        throw new RuntimeException("Invalid " + (Object)((Object)direction) + " binding configuration.  No <jb:bean> configurations found.");
    }

    private static enum SmooksTransformationType {
        SMOOKS,
        XML2JAVA,
        JAVA2XML;

    }
}

