/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.smooks.internal;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.milyn.Smooks;
import org.milyn.container.ApplicationContext;
import org.milyn.container.plugin.SourceFactory;
import org.milyn.payload.Export;
import org.milyn.payload.Exports;
import org.milyn.payload.JavaResult;
import org.milyn.payload.StringResult;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.config.model.SmooksTransformModel;

@Scannable(value=false)
public class SmooksTransformer
extends BaseTransformer {
    private static Logger _log = Logger.getLogger(SmooksTransformer.class);
    private Smooks _smooks;
    private String _reportPath;
    private Export _export;

    protected SmooksTransformer(QName from, QName to, Smooks smooks, SmooksTransformModel model) {
        super(from, to);
        this._smooks = smooks;
        this._reportPath = model.getReportPath();
        this.init(model);
    }

    public Object transform(Object from) {
        if (from == null) {
            _log.debug((Object)"Null from payload passed to SmooksTransformer.  Returning null.");
            return null;
        }
        Source source = SourceFactory.getInstance().createSource(from);
        if (this._export != null) {
            Result result = this.newResultInstance();
            this._smooks.filterSource(source, new Result[]{result});
            return this.extractResultData(result);
        }
        this._smooks.filterSource(source);
        return from;
    }

    public void setReportPath(String reportPath) {
        this._reportPath = reportPath;
    }

    private void init(SmooksTransformModel model) {
        Exports exports = Exports.getExports((ApplicationContext)this._smooks.getApplicationContext());
        if (exports == null) {
            _log.debug((Object)("Smooks configuration '" + model.getConfig() + "'will not make updates to the Exchange Message payload because it does not define any <core:exports>.  See Smooks User Guide."));
            return;
        }
        if (exports.getExports().size() != 1) {
            throw new SwitchYardException("Invalid Smooks configuration file.  Must define an <core:exports> section with a single <core:export>.  See Smooks User Guide.");
        }
        this._export = (Export)exports.getExports().iterator().next();
        Class exportType = this._export.getType();
        if (StringResult.class.isAssignableFrom(exportType)) {
            return;
        }
        if (JavaResult.class.isAssignableFrom(exportType)) {
            return;
        }
        throw new SwitchYardException("Unsupported Smooks <core:export> type '" + exportType.getName() + "'.  Only supports StringResult or JavaResult.");
    }

    private Result newResultInstance() {
        Class resultType = this._export.getType();
        try {
            return (Result)resultType.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Unexpected exception while creating an instance of Result type '" + resultType.getName() + "'.", (Throwable)e);
        }
    }

    private Object extractResultData(Result result) {
        if (result instanceof StringResult) {
            return ((StringResult)result).getResult();
        }
        if (result instanceof JavaResult) {
            return ((JavaResult)result).extractFromResult((JavaResult)result, this._export);
        }
        return null;
    }
}

