/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model.v1;

import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseMarshaller;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.transform.config.model.v1.V1DozerFileEntryModel;
import org.switchyard.transform.config.model.v1.V1DozerMappingFilesModel;
import org.switchyard.transform.config.model.v1.V1DozerTransformModel;
import org.switchyard.transform.config.model.v1.V1JAXBTransformModel;
import org.switchyard.transform.config.model.v1.V1JSONTransformModel;
import org.switchyard.transform.config.model.v1.V1JavaTransformModel;
import org.switchyard.transform.config.model.v1.V1SmooksTransformModel;
import org.switchyard.transform.config.model.v1.V1XsltTransformModel;

public class V1TransformMarshaller
extends BaseMarshaller {
    private static final String TRANSFORM_JAVA = "transform.java";
    private static final String TRANSFORM_SMOOKS = "transform.smooks";
    private static final String TRANSFORM_JSON = "transform.json";
    private static final String TRANSFORM_XSLT = "transform.xslt";
    private static final String TRANSFORM_JAXB = "transform.jaxb";
    private static final String TRANSFORM_DOZER = "transform.dozer";

    public V1TransformMarshaller(Descriptor desc) {
        super(desc);
    }

    public Model read(Configuration config) {
        String name = config.getName();
        Descriptor desc = this.getDescriptor();
        if (name.equals(TRANSFORM_JAVA)) {
            return new V1JavaTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_SMOOKS)) {
            return new V1SmooksTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_JSON)) {
            return new V1JSONTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_XSLT)) {
            return new V1XsltTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_JAXB)) {
            return new V1JAXBTransformModel(config, desc);
        }
        if (name.equals(TRANSFORM_DOZER)) {
            return new V1DozerTransformModel(config, desc);
        }
        if (name.equals("mappingFiles")) {
            return new V1DozerMappingFilesModel(config, desc);
        }
        if (name.equals("entry")) {
            return new V1DozerFileEntryModel(config, desc);
        }
        return null;
    }
}

