/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.arquillian;

import java.util.List;
import java.util.function.Function;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.clustering.arquillian.ApplicationConfiguration;
import org.wildfly.clustering.arquillian.Deployment;
import org.wildfly.clustering.arquillian.DeploymentContainerConfiguration;
import org.wildfly.clustering.arquillian.DeploymentContainerRegistry;
import org.wildfly.clustering.arquillian.Lifecycle;
import org.wildfly.clustering.arquillian.Tester;

public abstract class AbstractITCase<C, A extends Archive<A>>
implements Runnable,
ApplicationConfiguration<C, A>,
DeploymentContainerConfiguration {
    @ArquillianResource
    private DeploymentContainerRegistry registry;
    private final Function<C, Tester> testerFactory;
    private final C configuration;

    @Override
    public DeploymentContainerRegistry getDeploymentContainerRegistry() {
        return this.registry;
    }

    protected AbstractITCase(Function<C, Tester> testerFactory, C configuration) {
        this.testerFactory = testerFactory;
        this.configuration = configuration;
    }

    @Override
    public void run() {
        Object archive = this.createArchive(this.configuration);
        List<Deployment> deployments = this.getDeploymentContainers().stream().map(container -> container.deploy((Archive<?>)archive)).toList();
        try (Lifecycle composite = Lifecycle.composite(deployments);
             Tester tester = this.testerFactory.apply(this.configuration);){
            tester.accept(deployments);
        }
    }
}

