/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.arquillian;

import java.util.Collection;

public interface Lifecycle
extends AutoCloseable {
    public void start();

    public void stop();

    public boolean isStarted();

    @Override
    default public void close() {
        if (this.isStarted()) {
            this.stop();
        }
    }

    public static Lifecycle composite(final Collection<? extends Lifecycle> lifecycles) {
        return new Lifecycle(){

            @Override
            public boolean isStarted() {
                return lifecycles.stream().anyMatch(Lifecycle::isStarted);
            }

            @Override
            public void start() {
                lifecycles.forEach(Lifecycle::start);
            }

            @Override
            public void stop() {
                lifecycles.forEach(Lifecycle::stop);
            }

            @Override
            public void close() {
                lifecycles.stream().forEach(Lifecycle::close);
            }
        };
    }
}

